# Covariate-informed continuous-time gray-box modeling to identify responsiveness of postsurgical pain to opioid therapy

## Installation/Dependencies 
The following software was used in the development of this project. Best results will likely be achieved by running on
Linux or MacOS. Compatibility with Windows not guaranteed.

- [R 4.4.1](https://cran.r-project.org/): Dependency install script included; run `Rscript dependencies.R` to install.
    - Note that `stanpumpR` library for pharmacokinetic/pharmacodynamic modeling specifically requires the bundled
      version with fixes; at time of writing (Aug 23, 2024), the public repository has a bug that prevents running
      stanpump code outside of the package project directory.

## How to Run 
- Our experiments and analysis pipeline are fully automated using Makefile. Simply run the `make` command in order to 
  run experiments in the paper, assuming all dependencies have been installed. Note: this step can be somewhat lengthy.
- Performance metric tables are produced by RMarkdown notebooks `R/ablation_performance.Rmd` and
  `R/simulation_performance.Rmd` after `make` targets have been built
- If you wish to run your own parameters, run the following commands and consult their output for guidance:

  `Rscript R/simulation_study.R --help`
  
  `Rscript R/ablation_study.R --help`