data {
    int<lower=2> k; # Dimensionality of ordinal observations
    int<lower=1> m; # Number of controls
    int<lower=0> n; # Number of data points
    
    int<lower=1, upper=k> y[n];
    matrix[n, m] u;
    ordered[k-1] beta;
    
    vector[n] intervals;
    real mu0;
    real sigma0;
}

parameters {
    real<lower=0> sigma;
    vector[n+1] x;
    vector<lower=0>[m] A;
}

model {
    for (i in 1:n) {
        y[i] ~ ordered_logistic(x[i], beta);
        x[i+1] ~ normal(x[i] - dot_product(A, u[i]), sigma * sqrt(intervals[i]));
    }
    x[1] ~ normal(mu0, sigma0);
}
