ip_list=(\
"ip0" \
"ip1" \
"ip2" \
"ip3" \
"ip4" \
"ip5" \
"ip6" \
"ip7" \
"ip8" \
"ip9" \
"ip10" \
"ip11" \
"ip12" \
"ip13" \
"ip14" \
"ip15" \
)

batch_size=128
debug=0
epochs=32
gradient_acc=2
lr=0.001
lr_scheduler=cosine
input_size=224
margin_loss_m1=1.0
margin_loss_m2=0.0
margin_loss_m3=0.3
margin_loss_s=64
margin_loss_filter=0.75
model=IViT-L-14
num_classes=1000000
opt=adamw
output_dim=768

sample_rate=0.1
weight_decay=0.05
train_num_samples=392737216
train_data=/mnt/laion/laion_400M_fused/train


for((node_rank=0;node_rank<${#ip_list[*]};node_rank++));
do
  ssh ubuntu@${ip_list[node_rank]} "cd `pwd`;PATH=$PATH \
  CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 \
  NCCL_ALGO=Ring \
  NCCL_SOCKET_IFNAME=eth0 \
  NCCL_SOCKET_NTHREADS=8 \
  NCCL_NSOCKS_PERTHREAD=2 \
  torchrun --nproc_per_node 8 \
  --nnodes=${#ip_list[*]} \
  --node_rank=$node_rank \
  --master_addr=${ip_list[0]} \
  --master_port=22346  training_pfc/train_pfc_v2.py \
    --batch-size                   $batch_size \
    --debug                        $debug \
    --epochs                       $epochs \
    --gradient-acc                 $gradient_acc \
    --lr                           $lr \
    --lr-scheduler                 $lr_scheduler \
    --list-save-epochs             $list_save_epochs \
    --input-size                   $input_size \
    --model                        $model \
    --margin-loss-m1               $margin_loss_m1 \
    --margin-loss-m2               $margin_loss_m2 \
    --margin-loss-m3               $margin_loss_m3 \
    --margin-loss-s                $margin_loss_s \
    --margin-loss-filter           $margin_loss_filter \
    --num-classes                  $num_classes \
    --optimizer                    $opt \
    --output-dim                   $output_dim \
    --output                       /mnt/laion/laion_models/$0 \
    --sample-rate                  $sample_rate \
    --train-data                   $train_data \
    --train-num-samples            $train_num_samples \
    --resume                       $resume \
    --weight-decay                 $weight_decay" &
done
