
def generalized_lfsr(seed: int, taps: list[int], count: int, bit_width: int = 16):

    if seed == 0:
        raise ValueError("Seed must be non-zero.")
    if bit_width < max(taps) + 1:
        raise ValueError("bit_width must be greater than the largest tap index.")

    state = seed & ((1 << bit_width) - 1)
    states = []

    for _ in range(count):
        states.append(state)
        feedback = 0
        for t in taps:
            feedback ^= (state >> t) & 1
        state = ((state >> 1) | (feedback << (bit_width - 1))) & ((1 << bit_width) - 1)

    return states


def get_lfsr_states(seed: int, k: int, count: int):

    lfsr_table = {
        2:  [0, 1],
        3:  [0, 1],
        4:  [0, 1],
        5:  [0, 2],
        6:  [0, 1],
        7:  [0, 1],
        8:  [0, 2, 3, 4],
        9:  [0, 4],
        10: [0, 3],
        11: [0, 2],
        12: [0, 1, 2, 8],
        13: [0, 1, 2, 5],
        14: [0, 1, 2, 12],
        15: [0, 1],
        16: [0, 1, 3, 12],
        17: [0, 3],
        18: [0, 7],
        19: [0, 1, 2, 5],
        20: [0, 3],
        21: [0, 2],
        22: [0, 1],
        23: [0, 5],
        24: [0, 1, 2, 7],
    }

    if k not in lfsr_table:
        raise ValueError(f"LFSR length k={k} is not supported in the table (must be 2–24).")

    taps = lfsr_table[k]
    return generalized_lfsr(seed=seed, taps=taps, count=count, bit_width=k)


