from scipy.optimize import minimize
import math
import numpy as np
import matplotlib.pyplot as plt
import random as rn
import time



def  Norm(x):
	squares = [y**2 for y in x]
	a = sum(squares)
	return a**(1/2) 


def  pNorm(x):
	powers = [np.abs(y)**p for y in x]
	a = sum(powers)
	return a**(1/p) 


def dot(x,y):
	return sum(   [x[i]*y[i] for i in range(0,len(x)) ]   )  


def ExpectedLoss(x):
	return sum(   [x[i]*Expectation[i] for i in range(0,len(x)) ]   ) 



def dotCC(x):
	return sum(   [x[i]*CCost[i] for i in range(0,len(x)) ]   ) 


def  Distance(x):			
	a=sum(  [ (x[i]-y[i])**2  for i in range(0,len(x)) ]   )  # takes x as vector
	return a**(1/2)

def SchattenNorm(x,p):                                   # Schatten norm of matrix x with parameter p, takes x as vector
	x = np.reshape( x,(n,n) ) 	
	sv = np.linalg.svd(x)[0][0]
	a =  sum( [ np.abs(x)**p  for x in sv  ])
	return a**(1/p)	



def GreedySubgradient(Costs,eta): 

	Benchmarks = [0]
	Regret = [0]
	ObservedCosts = [[0]*d]
	CCost = np.array([0]*d)    # cumulative cost
	y = np.array( [0] )
	Actions = [ [0]*d] 
	Losses =   [0]   
	for i in range(1,N):
		#print("New cost =", Costs[i-1])		
		CCost = np.add(CCost, Costs[i-1])
		#print("CumulativeCost=",CCost)
		#ObservedCosts = ObservedCosts + [list(Costs[i-1])]
		#print("ObservedCosts=",ObservedCosts)
		#global y
		y = Actions[i-1] - eta*Costs[i-1]*(1/np.sqrt(i))
		X = y / Norm(y) 
		Actions = Actions + [X]
	return Actions


def PseudoRegret(Costs,Actions): 
	
	Regret = [0]
	cons= ({'type': 'ineq', 'fun': lambda x: -pNorm( x ) +1})  
	CCost = np.array([0]*d)
	Benchmark = np.array([0]*d)
	for n in range(1, len(Actions)):
		CCost = np.add( CCost, Costs[n])
		Benchmark =  [0,-1]
		#res = minimize( dotCC, Benchmark, constraints=cons)
		#Benchmark = list(res.x)
		r = [ dot( Actions[i], Costs[i] ) - dot( Benchmark, Costs[i] ) for i in range(0,n)]
		R = sum(r)
		Regret = Regret + [R]
	return Regret
		#Benchmarks = Benchmarks + [B]
		

def regret(Costs,Actions): 
	
	Regret = [0]
	cons= ({'type': 'ineq', 'fun': lambda x: -pNorm( x ) +1})  
	#global CCcost	
	CCost = np.array([0]*d)
	Benchmark = np.array([0]*d)
	for n in range(1, len(Actions)):
		CCost = np.add( CCost, Costs[n])
		Benchmark = - 	CCost/Norm(CCost)	
		r = [ dot( Actions[i], Costs[i] ) - dot( Benchmark, Costs[i] ) for i in range(0,n)]
		R = sum(r)
		Regret = Regret + [R]
	return Regret
		#Benchmarks = Benchmarks + [B]		 


def ExpectedCosts(r):	                       
	a = [0,1] 	
	return a

def Noise(NoiseSize):
	N = [rn.choice([-1,1]) for x in range(0,d)]
	norm = Norm(N)
	N =  [NoiseSize*x/norm for x in N]
	return N

def EndNoise(NoiseSize):
	N = [0]*(d-1) + [rn.choice([-1,1])]
	return N
	
def CostHistory(r):
	a = ExpectedCosts(r)
	H = [np.add(a,Noise(NoiseSize)) for x in range(0,N)] # Change to EndNoise(NoiseSize) to get noise type (2), or Noise(NoiseSize)  to get noise type (1)
	return H
 
start_time = time.time()

 
NoiseSize = 1

p = 2

r = 0

d = 2

N = 100

eta = 1
 
S= 25

print("\n \n \n \n \n Expectation =", ExpectedCosts(r) )

Total = [0]*N

 
for p in [2]: # use this to loop over parameters
 

#for p in [2]: 
	Total = [0]*N
	print("Starting p = ", p)	
	for n in range (0,S):
		print("Starting Sample Number", n)
		C = CostHistory(r)
		X = GreedySubgradient(C,1)
		#Expectation = ExpectedCosts(r)
		R =  regret(C,X)
		plt.plot(R, color='red', alpha = 0.1)
		Total = [Total[i] + R[i] for i in range(0,N) ]
	
	plt.plot(R, color='red', alpha = 0.1, label = 'Samples')
	Average = [x/S for x in Total]
	plt.plot(Average,label = " Mean of Samples", color = 'black')
 
end_time = time.time()
print("\n execution time = ",    end_time-start_time, "\n")

#plt.title("dimension = " +str(d)+", p = "+str(p)+", Samples = " +str(S)+ ", r = " +str(r))
plt.title("dimension = " +str(d)+  ", p = 2, r = $\infty$, Samples = " +str(S)+", Noise Type  (1)" )
plt.ylabel("Regret")
plt.xlabel("Number of turns")
 
 

x1 = int(N-1)
x2 = int((N-1)/2)
y1 = Average[x1]
y2 = Average[x2]

D1 = (y2-y1)/(np.sqrt(x2)-np.sqrt(x1))
C1 = y1 -D1*np.sqrt(x1)
testpower = [ D1*np.sqrt(x) + C1  for x in range(0,N)]
plt.plot(testpower, label = "$D_1 \sqrt{n}+ C_1$", color="green")

 
testlog = [Average[N-1] * np.log((x+1))/np.log(N) for x in range(0,N)]
plt.plot(testlog, label = "$D_2$ log (n+1)", color="blue")

 

plt.legend(loc = 'lower right')
plt.show()

 
