import numpy as np
import scipy.sparse as sp
import numba
from hk_solver import *
large_graph = ['com-friendster', 'ogbn-papers100M']
graph_names = ['Cora', 'Citeseer', 'ogbn-arxiv', 'as-skitter', 'ogbn-proteins',
               'com-orkut', 'cit-patent', 'ogbl-ppa', 'ogbn-products', 'wiki-talk', 'com-youtube', 'ogbn-mag',
               'soc-lj1', 'reddit', 'pubmed', 'wiki-en21', 'com-friendster', 'ogbn-papers100M']

result_names = ['local_sor_opers', 'local_sor_algo_times', 'global_sor_opers',
            'global_sor_algo_times', 'local_gs_opers', 'local_gs_algo_times',
            'global_gs_opers', 'global_gs_algo_times', 'local_gd_opers',
            'local_gd_algo_times', 'global_gd_opers', 'global_gd_algo_times']
path = './dataset/'
all_result = {}
ppr_result = np.load('./results/ppr_exp_result_new.npy', allow_pickle=True)
ppr_result = ppr_result.reshape(1, -1)[0][0]

for graph_name in graph_names:
    graph_path = path + graph_name + '/'
    adj_matrix = sp.load_npz(graph_path + graph_name + '_csr-mat.npz')
    degree = np.array(adj_matrix.sum(1)).flatten()
    indices = adj_matrix.indices
    indptr = adj_matrix.indptr
    n = len(indptr) - 1
    m = len(indices)
    tau = 10.0
    omega = 1.2
    eps = 1 / np.sqrt(n)
    np.random.seed(17)
    s_nodes = ppr_result[graph_name][0]
    print(graph_name, end=':\n')
    graph_result = solve_a_graph_all(n, indptr, indices, degree, tau, eps, omega, graph_name, s_nodes)
    for i in range(len(result_names)):
        print(result_names[i], ':', graph_result[i + 1].mean())
    print()
    all_result[graph_name] = graph_result
    np.save('./results/hk_exp_result_new.npy', all_result)
