import numpy as np
import scipy.sparse as sp
import numba
from hk_solver import *
import sys
import os

all_graph = ['Cora', 'Citeseer', 'ogbn-arxiv', 'as-skitter', 'ogbn-proteins', 'com-orkut',
               'cit-patent', 'ogbl-ppa', 'ogbn-products', 'wiki-talk', 'com-youtube', 'ogbn-mag',
               'soc-lj1', 'reddit', 'pubmed', 'wiki-en21', 'com-friendster', 'ogbn-papers100M']

graph_names = ['Citeseer', 'ogbn-arxiv', 'com-youtube']
path = './dataset/'

exp_result = np.load('./results/ppr_exp_result_new.npy', allow_pickle=True)
exp_result = exp_result.reshape(1, -1)[0][0]

for graph_name in graph_names:
    all_result = {}
    graph_path = path + graph_name + '/'
    adj_matrix = sp.load_npz(graph_path + graph_name + '_csr-mat.npz')
    indices = adj_matrix.indices
    indptr = adj_matrix.indptr
    n = len(indptr) - 1
    degree = np.array(adj_matrix.sum(1)).flatten()
    tau = 10.0
    omega = 1.2
    eps = np.power(2.0, 8) / np.sqrt(n)
    mineps = np.power(2.0, -24) / np.sqrt(n)
    np.random.seed(17)
    s_nodes = exp_result[graph_name][0]
    while True:
        if eps >= 0.01:
            eps /= 2
            continue
        print('hk', graph_name, eps, end=' ')
        graph_result = solve_a_graph_all(n, indptr, indices, degree, tau, eps, omega, graph_name, s_nodes)
        print(graph_result[2].mean(), graph_result[4].mean(), graph_result[6].mean(), (graph_result[4] / graph_result[2]).mean())
        all_result[eps] = graph_result
        np.save('./results/' + graph_name +'/hk_exp_ratio_result_new.npy', all_result)
        eps /= 2
        if eps < mineps or (graph_result[4] / graph_result[2]).mean() < 0.8:
            break

