import numpy as np
import scipy.sparse as sp
import numba
from katz_solver import *

large_graph = ['com-friendster', 'ogbn-papers100M']
graph_names = ['Cora', 'Citeseer', 'ogbn-arxiv', 'as-skitter', 'ogbn-proteins',
               'com-orkut', 'cit-patent', 'ogbl-ppa', 'ogbn-products', 'wiki-talk', 'com-youtube', 'ogbn-mag',
               'soc-lj1', 'reddit', 'pubmed', 'wiki-en21', 'com-friendster', 'ogbn-papers100M']

path = './dataset/'

all_result = {}

lambda_result = np.load('./results/katz_exp_lambda.npy', allow_pickle=True)
lambda_result = lambda_result.reshape(1, -1)[0][0]

lambda_min_result = np.load('./results/katz_exp_lambda_min.npy', allow_pickle=True)
lambda_min_result = lambda_min_result.reshape(1, -1)[0][0]

exp_result = np.load('./results/ppr_exp_result_new.npy', allow_pickle=True)
exp_result = exp_result.reshape(1, -1)[0][0]

for graph_name in graph_names:
    graph_path = path + graph_name + '/'
    adj_matrix = sp.load_npz(graph_path + graph_name + '_csr-mat.npz')
    indices = adj_matrix.indices
    indptr = adj_matrix.indptr
    n = len(indptr) - 1
    m = len(indices)
    degree = np.array(adj_matrix.sum(1)).flatten()
    eps = 1 / m
    lambda_1 = lambda_result[graph_name]
    lambda_min = lambda_min_result[graph_name]
    alpha = 1. / (lambda_1 + 1)
    l_max = 1. - alpha * lambda_min
    mu_min = 1. - alpha * lambda_1
    np.random.seed(17)
    s_nodes = exp_result[graph_name][0]
    print(graph_name, end=' ')
    graph_result = solve_a_graph_cheby(n, indptr, indices, degree, alpha, l_max, mu_min, eps, graph_name, s_nodes)
    print(graph_result[2].mean(), graph_result[4].mean(), graph_result[1].mean(), graph_result[3].mean())
    all_result[graph_name] = graph_result
    np.save('./results/katz_exp_result_cheby.npy', all_result)
