import numpy as np
import scipy.sparse as sp
import numba
from ppr_solver import *

graph_names = ['Cora', 'Citeseer', 'ogbn-arxiv', 'as-skitter', 'ogbn-proteins',
               'com-orkut', 'cit-patent', 'ogbl-ppa', 'ogbn-products', 'wiki-talk', 'com-youtube', 'ogbn-mag',
               'soc-lj1', 'reddit', 'pubmed', 'wiki-en21', 'com-friendster', 'ogbn-papers100M']
path = './dataset/'
test_num = 50
alpha = 0.1
alpha = alpha / (2 - alpha)
mu = (1. - alpha) / (1. + alpha)
omega = 1. + (mu / (1. + np.sqrt(1. - mu ** 2.))) ** 2.
alpha = 2 * alpha / (1 + alpha)
all_result = {}

for graph_name in graph_names:
    result_path = "./results/" + graph_name
    if not os.path.exists(result_path):
        os.makedirs(result_path)
    test_num = 50
    graph_path = path + graph_name + '/'
    adj_matrix = sp.load_npz(graph_path + graph_name + '_csr-mat.npz')
    indices = adj_matrix.indices
    indptr = adj_matrix.indptr
    n = len(indptr) - 1
    m = len(indices)
    degree = np.array(adj_matrix.sum(1)).flatten()
    eps = 1 / n
    np.random.seed(17)
    s_nodes = np.random.randint(n, size=test_num)
    s_nodes = np.array(list(np.unique(s_nodes).astype(np.int32)))
    print(graph_name, n + m, end=' ')
    graph_result = solve_a_graph_all(n, indptr, indices, degree, alpha, eps, omega, graph_name, s_nodes)
    print(graph_result[1].mean(), graph_result[5].mean())
    all_result[graph_name] = graph_result
    np.save('./results/ppr_exp_result_new.npy', all_result)
