##
# New scaling experiments
##
##
# Setup:
# lr=0.1, steps=120k, record final_acc, no exceptions
## Demonstrate:
# Model param scaling
# Scaling for invariant archs
# SAM scaling
# Repetition scaling [but confine repetitions to this part]
## Baseline augmentations to test scaling for:
# 1) Hflip+rcrop
# 2) TrivialAug&Flips&Crops
# 3) Hflip
# 4) Perspectives
#
# Maybe later:
# 5) Augmix&Flips&Crops
# 6) [fixed] Cutout, [fixed] RandomGaussianBlur
# Run with single exps for now, repeat later

# B) repetition scaling for TrivialAug&Flips&Crops
# base model
# r=1
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}

# r=2
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}


# r=4
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}


# r=8
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}



# r=16
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_trivialaug_hflip_rcrop_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train.TrivialAugmentWide=31 +data.db.augmentations_train.RandomCrop=[32,4] +data.db.augmentations_train={RandomHorizontalFlip:0.5}




# B) repetition scaling for Hflip
# base model
# r=1
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=1 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}

# r=2
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}


# r=4
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=4 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}


# r=8
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=8 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}



# r=16
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}
python train_sgd_variant.py name=sgd_hflip_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=16 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:0.5}

# r=2 det
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=1000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=2000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=3000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=6000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=12000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=24000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=48000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=96000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=128000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=144000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=168000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=180000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
python train_sgd_variant.py name=sgd_hflip_det_rep hyp=base_da data=CINIC10 data.size=192000 data/db=LMDB data.db.rounds=2 data.db.path=/scratch1/jonas0/lmdb +data.db.augmentations_train={RandomHorizontalFlip:1.0} data.db.first_round_clean=True
