##
# New scaling experiments
##
##
# Setup:
# lr=0.1, steps=120k, record final_acc, no exceptions
## Demonstrate:
# Model param scaling
# Scaling for invariant archs
# SAM scaling
# Repetition scaling [but confine repetitions to this part]
## Baseline augmentations to test scaling for:
# 1) Hflip+rcrop
# 2) TrivialAug&Flips&Crops
# 3) Hflip
# 4) Perspectives
#
# Maybe later:
# 5) Augmix&Flips&Crops
# 6) [fixed] Cutout, [fixed] RandomGaussianBlur
# Run with single exps for now, repeat later

# C) scaling for e2cnn

python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=1000  hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=2000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=3000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=6000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=12000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=24000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=48000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=96000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=128000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=144000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=168000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=180000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=e2cnn data.size=192000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True



# and InvariantResNet
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=1000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=2000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=3000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=6000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=12000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=24000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=48000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=96000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=128000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=144000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=168000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=180000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=flipinvariantresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=192000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True


# and OrbitResNet
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=1000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=2000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=3000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=6000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=12000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=24000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=48000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=96000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=128000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=144000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=168000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=180000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_hflip hyp=base_da data=CINIC10 model=orbitresnet +data.augmentations_train={RandomHorizontalFlip:0.5} data.size=192000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.sub_batch=32 hyp.grad_reg.guard_bn=True


# and Lieconv
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=1000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=2000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=3000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=6000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=12000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=24000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=48000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=96000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=128000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=144000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=168000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=180000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
python train_sgd_variant.py name=sgd_sam_noaug hyp=base_da data=CINIC10 model=lieconv data.size=192000 hyp.grad_reg.eps=5e-2 hyp.grad_reg.block_strength=0.1 hyp.grad_reg.rate_grad_rescaling=False hyp.grad_reg.guard_bn=True
