# LLID Codebase

Code accompanying the paper "Relating Regularization and Generalization through the Intrinsic Dimension of Activations" submitted to HITY 2022 by anonymous authors.

## Installation

Create and activate conda environment:
```bash
conda env create -f env.yaml 
conda activate llid
```

## Training Models

Run
```bash
python train.py +exp=EXP base_dir=BASE_DIR
```

Where EXP is
- "cifar10" for ResNet-18 on CIFAR-10 no ID tracking
- "cifar10_id" for ResNet-18 on CIFAR-10 with ID tracking
- "cifar100" for ResNet-18 on CIFAR-100 no ID tracking
- "cifar100_id" for ResNet-18 on CIFAR-100 with ID tracking
- "math_equations" for a transfomer model on the modular division mod 97 task with no ID tracking
- "math_equations_id" for a transfomer model on the modular division mod 97 task with ID tracking

and BASE_DIR is the root directory of the repo.

This project uses a combination of hydra and pytorch lightning. To see additional configuration options please see the "./config" folder.

## Displaying results on tensorboard

```bash
tensorboard --logdir outputs/
```