 # -- coding: utf-8 --**

"""
Created on 2024/10/25

@author: Ruoyu Chen
"""

import argparse

import os
import os
import json
import cv2
import numpy as np
from matplotlib import pyplot as plt
from PIL import Image
from torchvision import transforms
import torch
import torch.nn as nn

from tqdm import tqdm
import csv


import xml.etree.ElementTree as ET


def parse_args():
    parser = argparse.ArgumentParser(description='Energy Point Game')
    parser.add_argument('--Datasets',
                        type=str,
                        default='datasets/coco/val2017',
                        help='Datasets.')
    parser.add_argument('--explanation-dir',
                        type=str,
                        default='baseline_results/tradition-detector-coco-correctly/yolo_v3-DRISE',
                        help='Save path for saliency maps generated by our methods.')
    parser.add_argument('--ckpt_path',
                        type=str,
                        default='/mnt/huawei/jiaoxh/CGC/checkpoint/b16_224/divide_v1/eclip-epoch10-divide-lambda0.5/model_best.pth.tar',
                        help='Save path for saliency maps generated by our methods.')
    parser.add_argument('--arch',
                        type=str,
                        default='resnet18',
                        help='Save path for saliency maps generated by our methods.')
    args = parser.parse_args()
    return args


def parse_xml(xml_file):
    tree = ET.parse(xml_file)
    root = tree.getroot()

    annotations = []
    size = root.find('size')
    w = int(size.find('width').text)
    h = int(size.find('height').text)
    for obj in root.findall('object'):
        bbox = obj.find('bndbox')
        # x -> w, y -> h
        # xmin = int(int(bbox.find('xmin').text) * 256.0 / w) - 16
        # ymin = int(int(bbox.find('ymin').text) * 256.0 / h) - 16
        # xmax = int(int(bbox.find('xmax').text) * 256.0 / w) - 16
        # ymax = int(int(bbox.find('ymax').text) * 256.0 / h) - 16
        xmin = int(int(bbox.find('xmin').text) * 224.0 / w)
        ymin = int(int(bbox.find('ymin').text) * 224.0 / h)
        xmax = int(int(bbox.find('xmax').text) * 224.0 / w)
        ymax = int(int(bbox.find('ymax').text) * 224.0 / h)
        class_name = obj.find('name').text

        annotations.append({
            'class_name': class_name,
            'bbox': [xmin, ymin, xmax, ymax]
        })

    return annotations


def energy_point_game(bbox, saliency_map):
    w, h = saliency_map.shape
    empty = np.zeros((w, h))

    for b in bbox:
        x1, y1, x2, y2 = b
        empty[y1:y2, x1:x2] = 1
        # empty[x1:x2, y1:y2] = 1
    mask_bbox = saliency_map * empty

    energy_bbox = mask_bbox.sum()
    energy_whole = saliency_map.sum() + 0.000000000001

    proportion = energy_bbox / energy_whole
    return proportion


def point_game(bbox, saliency_map):
    w, h = saliency_map.shape
    empty = np.zeros((w, h))

    for b in bbox:
        x1, y1, x2, y2 = b
        empty[y1:y2, x1:x2] = 1
        # empty[x1:x2, y1:y2] = 1
    mask_bbox = saliency_map * empty

    if mask_bbox.max() == saliency_map.max():
        return 1
    else:
        return 0


def generate_masks_torch(patch_size):
    """
    Generate masks for patches in a given image shape.

    Args:
    shape: Tuple (height, width, channels) representing the shape of the image.
    patch_size: The number of patches along one dimension (assuming square patches).

    Returns:
    masks: Tensor of shape (patch_size * patch_size, height, width, channels) containing the masks.
    """
    # 计算每个小块的宽度和高度
    patch_width = 224 // patch_size
    patch_height = 224 // patch_size

    # 初始化一个张量来存储所有掩码
    masks = torch.zeros((patch_size * patch_size, 1, 224, 224), dtype=torch.uint8)

    # 生成掩码
    for i in range(patch_size):
        for j in range(patch_size):
            # 计算当前小块的起始和结束位置
            start_x = j * patch_width
            start_y = i * patch_height
            end_x = start_x + patch_width
            end_y = start_y + patch_height

            # 创建掩码
            mask = torch.zeros((1, 224, 224), dtype=torch.uint8)
            mask[:, start_y:end_y, start_x:end_x] = 1

            # 将掩码存储到 masks 张量中
            masks[i * patch_size + j] = mask

    return masks


def read_csv_to_dict(file_path, element_type='int'):
    result_dict = {}

    with open(file_path, mode='r', newline='', encoding='utf-8') as csvfile:
        csvreader = csv.reader(csvfile)

        for row in csvreader:
            if not row:
                continue  # 跳过空行

            key = row[0]  # 第一列作为键
            if len(row) > 1:
                # 将剩余的列转换为整数列表
                if element_type == 'int':
                    values = [int(item) for item in row[1:] if item]
                else:
                    values = [float(item) for item in row[1:] if item]
            else:
                values = None  # 如果没有其他列，则值为None

            result_dict[key] = values

    return result_dict


def find_first_above_threshold(arr, threshold=0.7):
    for index, value in enumerate(arr):
        if value > threshold:
            return index
    return 35


def main(args):
    # image_paths = []
    # data_dir = '/mnt/huawei/jiaoxh/data/ImageNet100/val/'
    # for root, dirs, files in os.walk(data_dir):
    #     for file in files:
    #         if file.lower().endswith(('.jpeg')):
    #             image_paths.append(os.path.join(root, file))
    #
    #
    # classes = [d.name for d in os.scandir(data_dir) if d.is_dir()]
    # classes.sort()
    # class_to_idx = {cls_name: i for i, cls_name in enumerate(classes)}

    patches_tensor = generate_masks_torch(6)

    # file_path = 'search_result/result_baseline.csv'  # Point Game: 0.8244  Energy Point Game: 0.550820581644562
    # # file_path = 'search_result/result_cgc.csv'  #  Point Game: 0.8278  Energy Point Game: 0.5337514709454723
    # # file_path = 'search_result/result_reg.csv'  # Point Game: 0.8944  Energy Point Game: 0.6021727952302043
    # # file_path = 'search_result/result_two_loss.csv'  # Point Game: 0.8386  Energy Point Game: 0.6134799580441337
    # result = read_csv_to_dict(file_path)


    # wrong_list_baseline = ['n01692333/ILSVRC2012_val_00005227.JPEG', 'n01692333/ILSVRC2012_val_00010164.JPEG', 'n01692333/ILSVRC2012_val_00014312.JPEG', 'n01729322/ILSVRC2012_val_00002568.JPEG', 'n01729322/ILSVRC2012_val_00003098.JPEG', 'n01729322/ILSVRC2012_val_00013117.JPEG', 'n01729322/ILSVRC2012_val_00017346.JPEG', 'n01729322/ILSVRC2012_val_00037553.JPEG', 'n01729322/ILSVRC2012_val_00039530.JPEG', 'n01735189/ILSVRC2012_val_00023442.JPEG', 'n01749939/ILSVRC2012_val_00014252.JPEG', 'n01749939/ILSVRC2012_val_00014575.JPEG', 'n01749939/ILSVRC2012_val_00026739.JPEG', 'n01773797/ILSVRC2012_val_00043600.JPEG', 'n01773797/ILSVRC2012_val_00043646.JPEG', 'n01855672/ILSVRC2012_val_00016490.JPEG', 'n01855672/ILSVRC2012_val_00030245.JPEG', 'n01978455/ILSVRC2012_val_00004254.JPEG', 'n01978455/ILSVRC2012_val_00009697.JPEG', 'n01978455/ILSVRC2012_val_00013377.JPEG', 'n01978455/ILSVRC2012_val_00014921.JPEG', 'n01978455/ILSVRC2012_val_00023840.JPEG', 'n01980166/ILSVRC2012_val_00000818.JPEG', 'n01980166/ILSVRC2012_val_00010555.JPEG', 'n01980166/ILSVRC2012_val_00012779.JPEG', 'n01980166/ILSVRC2012_val_00015319.JPEG', 'n01980166/ILSVRC2012_val_00016554.JPEG', 'n01980166/ILSVRC2012_val_00021269.JPEG', 'n01980166/ILSVRC2012_val_00023339.JPEG', 'n01980166/ILSVRC2012_val_00030408.JPEG', 'n01980166/ILSVRC2012_val_00032547.JPEG', 'n01980166/ILSVRC2012_val_00035169.JPEG', 'n01980166/ILSVRC2012_val_00047880.JPEG', 'n01983481/ILSVRC2012_val_00020280.JPEG', 'n01983481/ILSVRC2012_val_00048921.JPEG', 'n02018207/ILSVRC2012_val_00001165.JPEG', 'n02018207/ILSVRC2012_val_00034172.JPEG', 'n02018207/ILSVRC2012_val_00035028.JPEG', 'n02085620/ILSVRC2012_val_00006079.JPEG', 'n02085620/ILSVRC2012_val_00011639.JPEG', 'n02085620/ILSVRC2012_val_00011900.JPEG', 'n02085620/ILSVRC2012_val_00013195.JPEG', 'n02085620/ILSVRC2012_val_00014409.JPEG', 'n02085620/ILSVRC2012_val_00017702.JPEG', 'n02085620/ILSVRC2012_val_00018882.JPEG', 'n02085620/ILSVRC2012_val_00023749.JPEG', 'n02085620/ILSVRC2012_val_00024590.JPEG', 'n02085620/ILSVRC2012_val_00029450.JPEG', 'n02085620/ILSVRC2012_val_00037791.JPEG', 'n02085620/ILSVRC2012_val_00049159.JPEG', 'n02086240/ILSVRC2012_val_00010550.JPEG', 'n02086240/ILSVRC2012_val_00035293.JPEG', 'n02086910/ILSVRC2012_val_00022099.JPEG', 'n02086910/ILSVRC2012_val_00033944.JPEG', 'n02087046/ILSVRC2012_val_00002521.JPEG', 'n02087046/ILSVRC2012_val_00004325.JPEG', 'n02087046/ILSVRC2012_val_00005639.JPEG', 'n02087046/ILSVRC2012_val_00006544.JPEG', 'n02087046/ILSVRC2012_val_00007511.JPEG', 'n02087046/ILSVRC2012_val_00011748.JPEG', 'n02087046/ILSVRC2012_val_00019566.JPEG', 'n02087046/ILSVRC2012_val_00036751.JPEG', 'n02087046/ILSVRC2012_val_00037669.JPEG', 'n02087046/ILSVRC2012_val_00041444.JPEG', 'n02087046/ILSVRC2012_val_00042449.JPEG', 'n02087046/ILSVRC2012_val_00044441.JPEG', 'n02089867/ILSVRC2012_val_00010950.JPEG', 'n02089867/ILSVRC2012_val_00014045.JPEG', 'n02089867/ILSVRC2012_val_00039788.JPEG', 'n02089973/ILSVRC2012_val_00000028.JPEG', 'n02089973/ILSVRC2012_val_00001777.JPEG', 'n02089973/ILSVRC2012_val_00003671.JPEG', 'n02089973/ILSVRC2012_val_00006505.JPEG', 'n02089973/ILSVRC2012_val_00011342.JPEG', 'n02089973/ILSVRC2012_val_00012875.JPEG', 'n02089973/ILSVRC2012_val_00025914.JPEG', 'n02089973/ILSVRC2012_val_00031859.JPEG', 'n02089973/ILSVRC2012_val_00033378.JPEG', 'n02089973/ILSVRC2012_val_00033633.JPEG', 'n02089973/ILSVRC2012_val_00033666.JPEG', 'n02089973/ILSVRC2012_val_00033862.JPEG', 'n02089973/ILSVRC2012_val_00034690.JPEG', 'n02089973/ILSVRC2012_val_00036191.JPEG', 'n02089973/ILSVRC2012_val_00037826.JPEG', 'n02089973/ILSVRC2012_val_00040069.JPEG', 'n02089973/ILSVRC2012_val_00043580.JPEG', 'n02089973/ILSVRC2012_val_00043610.JPEG', 'n02089973/ILSVRC2012_val_00045799.JPEG', 'n02089973/ILSVRC2012_val_00046454.JPEG', 'n02089973/ILSVRC2012_val_00048188.JPEG', 'n02090622/ILSVRC2012_val_00021450.JPEG', 'n02091831/ILSVRC2012_val_00005217.JPEG', 'n02091831/ILSVRC2012_val_00027058.JPEG', 'n02091831/ILSVRC2012_val_00027267.JPEG', 'n02091831/ILSVRC2012_val_00027810.JPEG', 'n02091831/ILSVRC2012_val_00030249.JPEG', 'n02091831/ILSVRC2012_val_00031817.JPEG', 'n02091831/ILSVRC2012_val_00045441.JPEG', 'n02093428/ILSVRC2012_val_00011387.JPEG', 'n02093428/ILSVRC2012_val_00024542.JPEG', 'n02093428/ILSVRC2012_val_00029242.JPEG', 'n02093428/ILSVRC2012_val_00035793.JPEG', 'n02099849/ILSVRC2012_val_00014655.JPEG', 'n02099849/ILSVRC2012_val_00021296.JPEG', 'n02099849/ILSVRC2012_val_00021344.JPEG', 'n02099849/ILSVRC2012_val_00038026.JPEG', 'n02099849/ILSVRC2012_val_00039150.JPEG', 'n02099849/ILSVRC2012_val_00044036.JPEG', 'n02100583/ILSVRC2012_val_00013971.JPEG', 'n02100583/ILSVRC2012_val_00018982.JPEG', 'n02100583/ILSVRC2012_val_00020489.JPEG', 'n02100583/ILSVRC2012_val_00026854.JPEG', 'n02104029/ILSVRC2012_val_00000507.JPEG', 'n02104029/ILSVRC2012_val_00005583.JPEG', 'n02104029/ILSVRC2012_val_00020132.JPEG', 'n02104029/ILSVRC2012_val_00024981.JPEG', 'n02104029/ILSVRC2012_val_00029261.JPEG', 'n02104029/ILSVRC2012_val_00035377.JPEG', 'n02105505/ILSVRC2012_val_00007059.JPEG', 'n02105505/ILSVRC2012_val_00007246.JPEG', 'n02106550/ILSVRC2012_val_00026005.JPEG', 'n02106550/ILSVRC2012_val_00026388.JPEG', 'n02106550/ILSVRC2012_val_00034771.JPEG', 'n02106550/ILSVRC2012_val_00036964.JPEG', 'n02106550/ILSVRC2012_val_00039235.JPEG', 'n02107142/ILSVRC2012_val_00000134.JPEG', 'n02107142/ILSVRC2012_val_00008343.JPEG', 'n02107142/ILSVRC2012_val_00030370.JPEG', 'n02107142/ILSVRC2012_val_00036045.JPEG', 'n02107142/ILSVRC2012_val_00041795.JPEG', 'n02107142/ILSVRC2012_val_00047225.JPEG', 'n02107142/ILSVRC2012_val_00047822.JPEG', 'n02108089/ILSVRC2012_val_00007001.JPEG', 'n02108089/ILSVRC2012_val_00016857.JPEG', 'n02108089/ILSVRC2012_val_00022458.JPEG', 'n02108089/ILSVRC2012_val_00024675.JPEG', 'n02108089/ILSVRC2012_val_00032406.JPEG', 'n02109047/ILSVRC2012_val_00001408.JPEG', 'n02109047/ILSVRC2012_val_00003069.JPEG', 'n02109047/ILSVRC2012_val_00006834.JPEG', 'n02109047/ILSVRC2012_val_00007915.JPEG', 'n02109047/ILSVRC2012_val_00017636.JPEG', 'n02109047/ILSVRC2012_val_00022814.JPEG', 'n02109047/ILSVRC2012_val_00023076.JPEG', 'n02109047/ILSVRC2012_val_00034748.JPEG', 'n02109047/ILSVRC2012_val_00048145.JPEG', 'n02113799/ILSVRC2012_val_00007866.JPEG', 'n02113799/ILSVRC2012_val_00021801.JPEG', 'n02113978/ILSVRC2012_val_00008137.JPEG', 'n02113978/ILSVRC2012_val_00033581.JPEG', 'n02113978/ILSVRC2012_val_00044767.JPEG', 'n02114855/ILSVRC2012_val_00000156.JPEG', 'n02114855/ILSVRC2012_val_00003765.JPEG', 'n02114855/ILSVRC2012_val_00004540.JPEG', 'n02114855/ILSVRC2012_val_00017231.JPEG', 'n02114855/ILSVRC2012_val_00034279.JPEG', 'n02114855/ILSVRC2012_val_00044732.JPEG', 'n02119022/ILSVRC2012_val_00004141.JPEG', 'n02119022/ILSVRC2012_val_00009066.JPEG', 'n02119022/ILSVRC2012_val_00010552.JPEG', 'n02119022/ILSVRC2012_val_00027828.JPEG', 'n02119022/ILSVRC2012_val_00029361.JPEG', 'n02123045/ILSVRC2012_val_00001341.JPEG', 'n02172182/ILSVRC2012_val_00020308.JPEG', 'n02172182/ILSVRC2012_val_00029442.JPEG', 'n02172182/ILSVRC2012_val_00040267.JPEG', 'n02231487/ILSVRC2012_val_00003586.JPEG', 'n02231487/ILSVRC2012_val_00035534.JPEG', 'n02231487/ILSVRC2012_val_00047601.JPEG', 'n02483362/ILSVRC2012_val_00004753.JPEG', 'n02483362/ILSVRC2012_val_00020997.JPEG', 'n02483362/ILSVRC2012_val_00027489.JPEG', 'n02483362/ILSVRC2012_val_00038037.JPEG', 'n02483362/ILSVRC2012_val_00045321.JPEG', 'n02488291/ILSVRC2012_val_00041180.JPEG', 'n02488291/ILSVRC2012_val_00046153.JPEG', 'n02701002/ILSVRC2012_val_00049302.JPEG', 'n02788148/ILSVRC2012_val_00039546.JPEG', 'n02804414/ILSVRC2012_val_00047081.JPEG', 'n02859443/ILSVRC2012_val_00012812.JPEG', 'n02869837/ILSVRC2012_val_00005523.JPEG', 'n02869837/ILSVRC2012_val_00013039.JPEG', 'n02869837/ILSVRC2012_val_00022447.JPEG', 'n02869837/ILSVRC2012_val_00031092.JPEG', 'n02869837/ILSVRC2012_val_00036133.JPEG', 'n02869837/ILSVRC2012_val_00038967.JPEG', 'n02869837/ILSVRC2012_val_00040107.JPEG', 'n02869837/ILSVRC2012_val_00048571.JPEG', 'n02877765/ILSVRC2012_val_00004124.JPEG', 'n02877765/ILSVRC2012_val_00012104.JPEG', 'n02877765/ILSVRC2012_val_00021233.JPEG', 'n02877765/ILSVRC2012_val_00022892.JPEG', 'n02877765/ILSVRC2012_val_00027381.JPEG', 'n02877765/ILSVRC2012_val_00028640.JPEG', 'n02877765/ILSVRC2012_val_00032877.JPEG', 'n02974003/ILSVRC2012_val_00000085.JPEG', 'n02974003/ILSVRC2012_val_00001861.JPEG', 'n02974003/ILSVRC2012_val_00003218.JPEG', 'n02974003/ILSVRC2012_val_00005948.JPEG', 'n02974003/ILSVRC2012_val_00011981.JPEG', 'n02974003/ILSVRC2012_val_00017438.JPEG', 'n02974003/ILSVRC2012_val_00024859.JPEG', 'n02974003/ILSVRC2012_val_00042653.JPEG', 'n03017168/ILSVRC2012_val_00004502.JPEG', 'n03017168/ILSVRC2012_val_00031125.JPEG', 'n03017168/ILSVRC2012_val_00035306.JPEG', 'n03017168/ILSVRC2012_val_00036909.JPEG', 'n03017168/ILSVRC2012_val_00047514.JPEG', 'n03032252/ILSVRC2012_val_00000532.JPEG', 'n03032252/ILSVRC2012_val_00015013.JPEG', 'n03032252/ILSVRC2012_val_00030652.JPEG', 'n03032252/ILSVRC2012_val_00034561.JPEG', 'n03032252/ILSVRC2012_val_00040393.JPEG', 'n03032252/ILSVRC2012_val_00040566.JPEG', 'n03032252/ILSVRC2012_val_00041963.JPEG', 'n03062245/ILSVRC2012_val_00002666.JPEG', 'n03062245/ILSVRC2012_val_00003798.JPEG', 'n03062245/ILSVRC2012_val_00004624.JPEG', 'n03062245/ILSVRC2012_val_00005812.JPEG', 'n03062245/ILSVRC2012_val_00017747.JPEG', 'n03062245/ILSVRC2012_val_00034375.JPEG', 'n03062245/ILSVRC2012_val_00040906.JPEG', 'n03085013/ILSVRC2012_val_00001687.JPEG', 'n03085013/ILSVRC2012_val_00012334.JPEG', 'n03085013/ILSVRC2012_val_00041349.JPEG', 'n03085013/ILSVRC2012_val_00048307.JPEG', 'n03259280/ILSVRC2012_val_00018603.JPEG', 'n03259280/ILSVRC2012_val_00026342.JPEG', 'n03259280/ILSVRC2012_val_00044281.JPEG', 'n03379051/ILSVRC2012_val_00019724.JPEG', 'n03379051/ILSVRC2012_val_00026706.JPEG', 'n03379051/ILSVRC2012_val_00029117.JPEG', 'n03424325/ILSVRC2012_val_00014992.JPEG', 'n03424325/ILSVRC2012_val_00027617.JPEG', 'n03424325/ILSVRC2012_val_00034204.JPEG', 'n03424325/ILSVRC2012_val_00047935.JPEG', 'n03492542/ILSVRC2012_val_00011209.JPEG', 'n03492542/ILSVRC2012_val_00014717.JPEG', 'n03492542/ILSVRC2012_val_00016772.JPEG', 'n03492542/ILSVRC2012_val_00021902.JPEG', 'n03492542/ILSVRC2012_val_00023887.JPEG', 'n03492542/ILSVRC2012_val_00038096.JPEG', 'n03492542/ILSVRC2012_val_00040967.JPEG', 'n03494278/ILSVRC2012_val_00015067.JPEG', 'n03494278/ILSVRC2012_val_00028082.JPEG', 'n03494278/ILSVRC2012_val_00031028.JPEG', 'n03530642/ILSVRC2012_val_00007383.JPEG', 'n03530642/ILSVRC2012_val_00022030.JPEG', 'n03530642/ILSVRC2012_val_00025504.JPEG', 'n03530642/ILSVRC2012_val_00030885.JPEG', 'n03530642/ILSVRC2012_val_00034883.JPEG', 'n03530642/ILSVRC2012_val_00042170.JPEG', 'n03584829/ILSVRC2012_val_00025935.JPEG', 'n03584829/ILSVRC2012_val_00037977.JPEG', 'n03594734/ILSVRC2012_val_00031738.JPEG', 'n03594734/ILSVRC2012_val_00037472.JPEG', 'n03594734/ILSVRC2012_val_00039172.JPEG', 'n03594734/ILSVRC2012_val_00039574.JPEG', 'n03594734/ILSVRC2012_val_00047544.JPEG', 'n03637318/ILSVRC2012_val_00007656.JPEG', 'n03637318/ILSVRC2012_val_00010971.JPEG', 'n03637318/ILSVRC2012_val_00012139.JPEG', 'n03637318/ILSVRC2012_val_00034586.JPEG', 'n03637318/ILSVRC2012_val_00048879.JPEG', 'n03642806/ILSVRC2012_val_00003142.JPEG', 'n03642806/ILSVRC2012_val_00011275.JPEG', 'n03642806/ILSVRC2012_val_00018063.JPEG', 'n03642806/ILSVRC2012_val_00031537.JPEG', 'n03642806/ILSVRC2012_val_00031843.JPEG', 'n03764736/ILSVRC2012_val_00001522.JPEG', 'n03764736/ILSVRC2012_val_00008765.JPEG', 'n03764736/ILSVRC2012_val_00010506.JPEG', 'n03764736/ILSVRC2012_val_00015009.JPEG', 'n03764736/ILSVRC2012_val_00027957.JPEG', 'n03764736/ILSVRC2012_val_00034439.JPEG', 'n03775546/ILSVRC2012_val_00028444.JPEG', 'n03775546/ILSVRC2012_val_00047849.JPEG', 'n03777754/ILSVRC2012_val_00003373.JPEG', 'n03777754/ILSVRC2012_val_00033556.JPEG', 'n03777754/ILSVRC2012_val_00034423.JPEG', 'n03777754/ILSVRC2012_val_00038670.JPEG', 'n03777754/ILSVRC2012_val_00040760.JPEG', 'n03777754/ILSVRC2012_val_00044245.JPEG', 'n03785016/ILSVRC2012_val_00048082.JPEG', 'n03794056/ILSVRC2012_val_00011238.JPEG', 'n03794056/ILSVRC2012_val_00045500.JPEG', 'n03794056/ILSVRC2012_val_00047199.JPEG', 'n03837869/ILSVRC2012_val_00016301.JPEG', 'n03837869/ILSVRC2012_val_00025846.JPEG', 'n03891251/ILSVRC2012_val_00011880.JPEG', 'n03891251/ILSVRC2012_val_00019835.JPEG', 'n03891251/ILSVRC2012_val_00029949.JPEG', 'n03903868/ILSVRC2012_val_00002193.JPEG', 'n03903868/ILSVRC2012_val_00005983.JPEG', 'n03903868/ILSVRC2012_val_00009123.JPEG', 'n03903868/ILSVRC2012_val_00011786.JPEG', 'n03903868/ILSVRC2012_val_00021853.JPEG', 'n03903868/ILSVRC2012_val_00024632.JPEG', 'n03903868/ILSVRC2012_val_00034875.JPEG', 'n03903868/ILSVRC2012_val_00035124.JPEG', 'n03903868/ILSVRC2012_val_00044198.JPEG', 'n03903868/ILSVRC2012_val_00046282.JPEG', 'n03903868/ILSVRC2012_val_00047667.JPEG', 'n03930630/ILSVRC2012_val_00017708.JPEG', 'n03930630/ILSVRC2012_val_00039963.JPEG', 'n03947888/ILSVRC2012_val_00009856.JPEG', 'n03947888/ILSVRC2012_val_00036199.JPEG', 'n03947888/ILSVRC2012_val_00043584.JPEG', 'n04026417/ILSVRC2012_val_00013522.JPEG', 'n04026417/ILSVRC2012_val_00013578.JPEG', 'n04026417/ILSVRC2012_val_00019537.JPEG', 'n04026417/ILSVRC2012_val_00019863.JPEG', 'n04026417/ILSVRC2012_val_00030487.JPEG', 'n04067472/ILSVRC2012_val_00012789.JPEG', 'n04067472/ILSVRC2012_val_00028684.JPEG', 'n04067472/ILSVRC2012_val_00034956.JPEG', 'n04067472/ILSVRC2012_val_00038171.JPEG', 'n04067472/ILSVRC2012_val_00044147.JPEG', 'n04099969/ILSVRC2012_val_00008768.JPEG', 'n04099969/ILSVRC2012_val_00009659.JPEG', 'n04099969/ILSVRC2012_val_00015390.JPEG', 'n04099969/ILSVRC2012_val_00037994.JPEG', 'n04099969/ILSVRC2012_val_00048622.JPEG', 'n04111531/ILSVRC2012_val_00045813.JPEG', 'n04127249/ILSVRC2012_val_00023036.JPEG', 'n04127249/ILSVRC2012_val_00023860.JPEG', 'n04127249/ILSVRC2012_val_00024308.JPEG', 'n04127249/ILSVRC2012_val_00025670.JPEG', 'n04127249/ILSVRC2012_val_00036087.JPEG', 'n04127249/ILSVRC2012_val_00040482.JPEG', 'n04136333/ILSVRC2012_val_00002902.JPEG', 'n04136333/ILSVRC2012_val_00019371.JPEG', 'n04136333/ILSVRC2012_val_00044155.JPEG', 'n04229816/ILSVRC2012_val_00009290.JPEG', 'n04229816/ILSVRC2012_val_00012859.JPEG', 'n04229816/ILSVRC2012_val_00015621.JPEG', 'n04229816/ILSVRC2012_val_00018711.JPEG', 'n04238763/ILSVRC2012_val_00001599.JPEG', 'n04238763/ILSVRC2012_val_00008565.JPEG', 'n04238763/ILSVRC2012_val_00010211.JPEG', 'n04238763/ILSVRC2012_val_00014178.JPEG', 'n04238763/ILSVRC2012_val_00024829.JPEG', 'n04238763/ILSVRC2012_val_00026669.JPEG', 'n04238763/ILSVRC2012_val_00030423.JPEG', 'n04238763/ILSVRC2012_val_00043886.JPEG', 'n04238763/ILSVRC2012_val_00049850.JPEG', 'n04336792/ILSVRC2012_val_00016751.JPEG', 'n04336792/ILSVRC2012_val_00028123.JPEG', 'n04336792/ILSVRC2012_val_00037415.JPEG', 'n04336792/ILSVRC2012_val_00044134.JPEG', 'n04336792/ILSVRC2012_val_00048036.JPEG', 'n04418357/ILSVRC2012_val_00030589.JPEG', 'n04418357/ILSVRC2012_val_00041249.JPEG', 'n04429376/ILSVRC2012_val_00001160.JPEG', 'n04429376/ILSVRC2012_val_00003519.JPEG', 'n04429376/ILSVRC2012_val_00013539.JPEG', 'n04429376/ILSVRC2012_val_00017455.JPEG', 'n04429376/ILSVRC2012_val_00025374.JPEG', 'n04429376/ILSVRC2012_val_00041720.JPEG', 'n04435653/ILSVRC2012_val_00003912.JPEG', 'n04435653/ILSVRC2012_val_00008528.JPEG', 'n04435653/ILSVRC2012_val_00022779.JPEG', 'n04435653/ILSVRC2012_val_00027447.JPEG', 'n04485082/ILSVRC2012_val_00009669.JPEG', 'n04493381/ILSVRC2012_val_00009864.JPEG', 'n04493381/ILSVRC2012_val_00012077.JPEG', 'n04493381/ILSVRC2012_val_00026655.JPEG', 'n04493381/ILSVRC2012_val_00039442.JPEG', 'n04517823/ILSVRC2012_val_00004252.JPEG', 'n04517823/ILSVRC2012_val_00018100.JPEG', 'n04517823/ILSVRC2012_val_00025595.JPEG', 'n04517823/ILSVRC2012_val_00025993.JPEG', 'n04517823/ILSVRC2012_val_00036519.JPEG', 'n04517823/ILSVRC2012_val_00037540.JPEG', 'n04589890/ILSVRC2012_val_00010471.JPEG', 'n04589890/ILSVRC2012_val_00011390.JPEG', 'n04589890/ILSVRC2012_val_00018029.JPEG', 'n04589890/ILSVRC2012_val_00028748.JPEG', 'n04589890/ILSVRC2012_val_00030215.JPEG', 'n04589890/ILSVRC2012_val_00030954.JPEG', 'n04592741/ILSVRC2012_val_00018330.JPEG', 'n07714571/ILSVRC2012_val_00002925.JPEG', 'n07714571/ILSVRC2012_val_00039050.JPEG', 'n07714571/ILSVRC2012_val_00043273.JPEG', 'n07715103/ILSVRC2012_val_00012240.JPEG', 'n07715103/ILSVRC2012_val_00020636.JPEG', 'n07715103/ILSVRC2012_val_00031499.JPEG', 'n07715103/ILSVRC2012_val_00039501.JPEG', 'n07753275/ILSVRC2012_val_00003549.JPEG', 'n07753275/ILSVRC2012_val_00020751.JPEG', 'n07753275/ILSVRC2012_val_00035283.JPEG', 'n07831146/ILSVRC2012_val_00004837.JPEG', 'n07831146/ILSVRC2012_val_00019588.JPEG', 'n07831146/ILSVRC2012_val_00035071.JPEG', 'n07836838/ILSVRC2012_val_00007307.JPEG', 'n07836838/ILSVRC2012_val_00014400.JPEG', 'n07836838/ILSVRC2012_val_00034148.JPEG', 'n13037406/ILSVRC2012_val_00043934.JPEG', 'n13040303/ILSVRC2012_val_00045228.JPEG']
    # wrong_list_three_loss = ['n01692333/ILSVRC2012_val_00004505.JPEG', 'n01692333/ILSVRC2012_val_00005227.JPEG', 'n01692333/ILSVRC2012_val_00014312.JPEG', 'n01692333/ILSVRC2012_val_00041887.JPEG', 'n01729322/ILSVRC2012_val_00002568.JPEG', 'n01729322/ILSVRC2012_val_00003098.JPEG', 'n01729322/ILSVRC2012_val_00013117.JPEG', 'n01729322/ILSVRC2012_val_00017346.JPEG', 'n01729322/ILSVRC2012_val_00037553.JPEG', 'n01729322/ILSVRC2012_val_00039530.JPEG', 'n01735189/ILSVRC2012_val_00023442.JPEG', 'n01735189/ILSVRC2012_val_00029744.JPEG', 'n01735189/ILSVRC2012_val_00032997.JPEG', 'n01749939/ILSVRC2012_val_00014252.JPEG', 'n01749939/ILSVRC2012_val_00014575.JPEG', 'n01749939/ILSVRC2012_val_00014769.JPEG', 'n01749939/ILSVRC2012_val_00025938.JPEG', 'n01749939/ILSVRC2012_val_00026739.JPEG', 'n01773797/ILSVRC2012_val_00043646.JPEG', 'n01855672/ILSVRC2012_val_00016490.JPEG', 'n01978455/ILSVRC2012_val_00004254.JPEG', 'n01978455/ILSVRC2012_val_00009697.JPEG', 'n01978455/ILSVRC2012_val_00011071.JPEG', 'n01978455/ILSVRC2012_val_00011137.JPEG', 'n01978455/ILSVRC2012_val_00013377.JPEG', 'n01978455/ILSVRC2012_val_00014921.JPEG', 'n01978455/ILSVRC2012_val_00023604.JPEG', 'n01978455/ILSVRC2012_val_00023840.JPEG', 'n01978455/ILSVRC2012_val_00024557.JPEG', 'n01978455/ILSVRC2012_val_00024885.JPEG', 'n01978455/ILSVRC2012_val_00029812.JPEG', 'n01978455/ILSVRC2012_val_00044632.JPEG', 'n01980166/ILSVRC2012_val_00010555.JPEG', 'n01980166/ILSVRC2012_val_00012779.JPEG', 'n01980166/ILSVRC2012_val_00013999.JPEG', 'n01980166/ILSVRC2012_val_00016554.JPEG', 'n01980166/ILSVRC2012_val_00032547.JPEG', 'n01983481/ILSVRC2012_val_00020280.JPEG', 'n01983481/ILSVRC2012_val_00048921.JPEG', 'n02009229/ILSVRC2012_val_00042026.JPEG', 'n02018207/ILSVRC2012_val_00001165.JPEG', 'n02018207/ILSVRC2012_val_00014805.JPEG', 'n02018207/ILSVRC2012_val_00034172.JPEG', 'n02018207/ILSVRC2012_val_00034734.JPEG', 'n02018207/ILSVRC2012_val_00035028.JPEG', 'n02085620/ILSVRC2012_val_00006079.JPEG', 'n02085620/ILSVRC2012_val_00011900.JPEG', 'n02085620/ILSVRC2012_val_00013195.JPEG', 'n02085620/ILSVRC2012_val_00014409.JPEG', 'n02085620/ILSVRC2012_val_00016757.JPEG', 'n02085620/ILSVRC2012_val_00017702.JPEG', 'n02085620/ILSVRC2012_val_00018882.JPEG', 'n02085620/ILSVRC2012_val_00020016.JPEG', 'n02085620/ILSVRC2012_val_00024590.JPEG', 'n02085620/ILSVRC2012_val_00028943.JPEG', 'n02085620/ILSVRC2012_val_00029289.JPEG', 'n02085620/ILSVRC2012_val_00029450.JPEG', 'n02085620/ILSVRC2012_val_00037791.JPEG', 'n02085620/ILSVRC2012_val_00041000.JPEG', 'n02085620/ILSVRC2012_val_00049159.JPEG', 'n02086240/ILSVRC2012_val_00010550.JPEG', 'n02086240/ILSVRC2012_val_00015738.JPEG', 'n02086240/ILSVRC2012_val_00035293.JPEG', 'n02086910/ILSVRC2012_val_00022099.JPEG', 'n02086910/ILSVRC2012_val_00033944.JPEG', 'n02087046/ILSVRC2012_val_00002521.JPEG', 'n02087046/ILSVRC2012_val_00004325.JPEG', 'n02087046/ILSVRC2012_val_00005639.JPEG', 'n02087046/ILSVRC2012_val_00006544.JPEG', 'n02087046/ILSVRC2012_val_00007511.JPEG', 'n02087046/ILSVRC2012_val_00011748.JPEG', 'n02087046/ILSVRC2012_val_00019566.JPEG', 'n02087046/ILSVRC2012_val_00033530.JPEG', 'n02087046/ILSVRC2012_val_00036751.JPEG', 'n02087046/ILSVRC2012_val_00041444.JPEG', 'n02087046/ILSVRC2012_val_00042449.JPEG', 'n02087046/ILSVRC2012_val_00044441.JPEG', 'n02089867/ILSVRC2012_val_00001538.JPEG', 'n02089867/ILSVRC2012_val_00008536.JPEG', 'n02089867/ILSVRC2012_val_00010950.JPEG', 'n02089867/ILSVRC2012_val_00014045.JPEG', 'n02089867/ILSVRC2012_val_00036492.JPEG', 'n02089867/ILSVRC2012_val_00039788.JPEG', 'n02089973/ILSVRC2012_val_00000028.JPEG', 'n02089973/ILSVRC2012_val_00004774.JPEG', 'n02089973/ILSVRC2012_val_00006505.JPEG', 'n02089973/ILSVRC2012_val_00011342.JPEG', 'n02089973/ILSVRC2012_val_00025914.JPEG', 'n02089973/ILSVRC2012_val_00029164.JPEG', 'n02089973/ILSVRC2012_val_00031859.JPEG', 'n02089973/ILSVRC2012_val_00033633.JPEG', 'n02089973/ILSVRC2012_val_00033666.JPEG', 'n02089973/ILSVRC2012_val_00033862.JPEG', 'n02089973/ILSVRC2012_val_00036191.JPEG', 'n02089973/ILSVRC2012_val_00043580.JPEG', 'n02089973/ILSVRC2012_val_00043610.JPEG', 'n02089973/ILSVRC2012_val_00045799.JPEG', 'n02089973/ILSVRC2012_val_00046454.JPEG', 'n02089973/ILSVRC2012_val_00048188.JPEG', 'n02090622/ILSVRC2012_val_00009378.JPEG', 'n02090622/ILSVRC2012_val_00017766.JPEG', 'n02090622/ILSVRC2012_val_00018654.JPEG', 'n02090622/ILSVRC2012_val_00036266.JPEG', 'n02090622/ILSVRC2012_val_00046420.JPEG', 'n02090622/ILSVRC2012_val_00049849.JPEG', 'n02091831/ILSVRC2012_val_00005217.JPEG', 'n02091831/ILSVRC2012_val_00019366.JPEG', 'n02091831/ILSVRC2012_val_00027267.JPEG', 'n02091831/ILSVRC2012_val_00030249.JPEG', 'n02091831/ILSVRC2012_val_00043901.JPEG', 'n02091831/ILSVRC2012_val_00045441.JPEG', 'n02093428/ILSVRC2012_val_00007527.JPEG', 'n02093428/ILSVRC2012_val_00011387.JPEG', 'n02093428/ILSVRC2012_val_00024542.JPEG', 'n02093428/ILSVRC2012_val_00029242.JPEG', 'n02093428/ILSVRC2012_val_00035793.JPEG', 'n02093428/ILSVRC2012_val_00039832.JPEG', 'n02099849/ILSVRC2012_val_00000668.JPEG', 'n02099849/ILSVRC2012_val_00005909.JPEG', 'n02099849/ILSVRC2012_val_00014655.JPEG', 'n02099849/ILSVRC2012_val_00015696.JPEG', 'n02099849/ILSVRC2012_val_00021296.JPEG', 'n02099849/ILSVRC2012_val_00021344.JPEG', 'n02099849/ILSVRC2012_val_00022066.JPEG', 'n02099849/ILSVRC2012_val_00025013.JPEG', 'n02099849/ILSVRC2012_val_00038026.JPEG', 'n02099849/ILSVRC2012_val_00039150.JPEG', 'n02100583/ILSVRC2012_val_00013971.JPEG', 'n02100583/ILSVRC2012_val_00018982.JPEG', 'n02100583/ILSVRC2012_val_00026854.JPEG', 'n02104029/ILSVRC2012_val_00005583.JPEG', 'n02104029/ILSVRC2012_val_00020132.JPEG', 'n02104029/ILSVRC2012_val_00024981.JPEG', 'n02104029/ILSVRC2012_val_00029261.JPEG', 'n02104029/ILSVRC2012_val_00035377.JPEG', 'n02105505/ILSVRC2012_val_00007059.JPEG', 'n02105505/ILSVRC2012_val_00007246.JPEG', 'n02105505/ILSVRC2012_val_00029354.JPEG', 'n02105505/ILSVRC2012_val_00032099.JPEG', 'n02106550/ILSVRC2012_val_00026005.JPEG', 'n02106550/ILSVRC2012_val_00039235.JPEG', 'n02107142/ILSVRC2012_val_00000134.JPEG', 'n02107142/ILSVRC2012_val_00008343.JPEG', 'n02107142/ILSVRC2012_val_00013297.JPEG', 'n02107142/ILSVRC2012_val_00022474.JPEG', 'n02107142/ILSVRC2012_val_00030370.JPEG', 'n02107142/ILSVRC2012_val_00036045.JPEG', 'n02107142/ILSVRC2012_val_00041795.JPEG', 'n02107142/ILSVRC2012_val_00047822.JPEG', 'n02108089/ILSVRC2012_val_00005495.JPEG', 'n02108089/ILSVRC2012_val_00007001.JPEG', 'n02108089/ILSVRC2012_val_00009189.JPEG', 'n02108089/ILSVRC2012_val_00016857.JPEG', 'n02108089/ILSVRC2012_val_00024675.JPEG', 'n02108089/ILSVRC2012_val_00032406.JPEG', 'n02108089/ILSVRC2012_val_00049040.JPEG', 'n02109047/ILSVRC2012_val_00001408.JPEG', 'n02109047/ILSVRC2012_val_00003069.JPEG', 'n02109047/ILSVRC2012_val_00004731.JPEG', 'n02109047/ILSVRC2012_val_00006834.JPEG', 'n02109047/ILSVRC2012_val_00007915.JPEG', 'n02109047/ILSVRC2012_val_00014257.JPEG', 'n02109047/ILSVRC2012_val_00017636.JPEG', 'n02109047/ILSVRC2012_val_00022814.JPEG', 'n02109047/ILSVRC2012_val_00023027.JPEG', 'n02109047/ILSVRC2012_val_00023076.JPEG', 'n02109047/ILSVRC2012_val_00034748.JPEG', 'n02109047/ILSVRC2012_val_00036235.JPEG', 'n02109047/ILSVRC2012_val_00038938.JPEG', 'n02109047/ILSVRC2012_val_00047250.JPEG', 'n02109047/ILSVRC2012_val_00048145.JPEG', 'n02113978/ILSVRC2012_val_00008137.JPEG', 'n02113978/ILSVRC2012_val_00014147.JPEG', 'n02113978/ILSVRC2012_val_00033581.JPEG', 'n02113978/ILSVRC2012_val_00044767.JPEG', 'n02114855/ILSVRC2012_val_00000156.JPEG', 'n02114855/ILSVRC2012_val_00003765.JPEG', 'n02114855/ILSVRC2012_val_00004540.JPEG', 'n02114855/ILSVRC2012_val_00004869.JPEG', 'n02114855/ILSVRC2012_val_00017231.JPEG', 'n02114855/ILSVRC2012_val_00034279.JPEG', 'n02114855/ILSVRC2012_val_00044021.JPEG', 'n02114855/ILSVRC2012_val_00044732.JPEG', 'n02119022/ILSVRC2012_val_00004141.JPEG', 'n02119022/ILSVRC2012_val_00009066.JPEG', 'n02119022/ILSVRC2012_val_00029361.JPEG', 'n02123045/ILSVRC2012_val_00001341.JPEG', 'n02123045/ILSVRC2012_val_00030706.JPEG', 'n02138441/ILSVRC2012_val_00006356.JPEG', 'n02138441/ILSVRC2012_val_00046136.JPEG', 'n02172182/ILSVRC2012_val_00006883.JPEG', 'n02172182/ILSVRC2012_val_00020308.JPEG', 'n02172182/ILSVRC2012_val_00040267.JPEG', 'n02231487/ILSVRC2012_val_00003586.JPEG', 'n02231487/ILSVRC2012_val_00030101.JPEG', 'n02231487/ILSVRC2012_val_00035534.JPEG', 'n02231487/ILSVRC2012_val_00047601.JPEG', 'n02483362/ILSVRC2012_val_00027489.JPEG', 'n02483362/ILSVRC2012_val_00038037.JPEG', 'n02483362/ILSVRC2012_val_00045321.JPEG', 'n02488291/ILSVRC2012_val_00003539.JPEG', 'n02488291/ILSVRC2012_val_00009359.JPEG', 'n02488291/ILSVRC2012_val_00018242.JPEG', 'n02488291/ILSVRC2012_val_00031939.JPEG', 'n02488291/ILSVRC2012_val_00038601.JPEG', 'n02488291/ILSVRC2012_val_00040839.JPEG', 'n02488291/ILSVRC2012_val_00041180.JPEG', 'n02488291/ILSVRC2012_val_00046153.JPEG', 'n02488291/ILSVRC2012_val_00046873.JPEG', 'n02701002/ILSVRC2012_val_00049302.JPEG', 'n02788148/ILSVRC2012_val_00016716.JPEG', 'n02788148/ILSVRC2012_val_00039546.JPEG', 'n02804414/ILSVRC2012_val_00004383.JPEG', 'n02804414/ILSVRC2012_val_00017317.JPEG', 'n02804414/ILSVRC2012_val_00023622.JPEG', 'n02804414/ILSVRC2012_val_00047081.JPEG', 'n02869837/ILSVRC2012_val_00005523.JPEG', 'n02869837/ILSVRC2012_val_00013039.JPEG', 'n02869837/ILSVRC2012_val_00017815.JPEG', 'n02869837/ILSVRC2012_val_00022447.JPEG', 'n02869837/ILSVRC2012_val_00030536.JPEG', 'n02869837/ILSVRC2012_val_00031092.JPEG', 'n02869837/ILSVRC2012_val_00048571.JPEG', 'n02877765/ILSVRC2012_val_00004124.JPEG', 'n02877765/ILSVRC2012_val_00006518.JPEG', 'n02877765/ILSVRC2012_val_00012104.JPEG', 'n02877765/ILSVRC2012_val_00021233.JPEG', 'n02877765/ILSVRC2012_val_00022892.JPEG', 'n02877765/ILSVRC2012_val_00032877.JPEG', 'n02974003/ILSVRC2012_val_00001861.JPEG', 'n02974003/ILSVRC2012_val_00003456.JPEG', 'n02974003/ILSVRC2012_val_00011981.JPEG', 'n02974003/ILSVRC2012_val_00017438.JPEG', 'n02974003/ILSVRC2012_val_00024859.JPEG', 'n02974003/ILSVRC2012_val_00031038.JPEG', 'n02974003/ILSVRC2012_val_00042653.JPEG', 'n03017168/ILSVRC2012_val_00001761.JPEG', 'n03017168/ILSVRC2012_val_00004502.JPEG', 'n03017168/ILSVRC2012_val_00024782.JPEG', 'n03017168/ILSVRC2012_val_00031125.JPEG', 'n03017168/ILSVRC2012_val_00035306.JPEG', 'n03017168/ILSVRC2012_val_00047514.JPEG', 'n03032252/ILSVRC2012_val_00000532.JPEG', 'n03032252/ILSVRC2012_val_00001894.JPEG', 'n03032252/ILSVRC2012_val_00015013.JPEG', 'n03032252/ILSVRC2012_val_00030652.JPEG', 'n03032252/ILSVRC2012_val_00034561.JPEG', 'n03032252/ILSVRC2012_val_00040393.JPEG', 'n03032252/ILSVRC2012_val_00040566.JPEG', 'n03032252/ILSVRC2012_val_00041963.JPEG', 'n03062245/ILSVRC2012_val_00002666.JPEG', 'n03062245/ILSVRC2012_val_00002826.JPEG', 'n03062245/ILSVRC2012_val_00003798.JPEG', 'n03062245/ILSVRC2012_val_00004624.JPEG', 'n03062245/ILSVRC2012_val_00005812.JPEG', 'n03062245/ILSVRC2012_val_00034375.JPEG', 'n03062245/ILSVRC2012_val_00040906.JPEG', 'n03062245/ILSVRC2012_val_00042799.JPEG', 'n03085013/ILSVRC2012_val_00012334.JPEG', 'n03085013/ILSVRC2012_val_00041349.JPEG', 'n03085013/ILSVRC2012_val_00042867.JPEG', 'n03085013/ILSVRC2012_val_00048307.JPEG', 'n03259280/ILSVRC2012_val_00018603.JPEG', 'n03259280/ILSVRC2012_val_00026342.JPEG', 'n03259280/ILSVRC2012_val_00030315.JPEG', 'n03259280/ILSVRC2012_val_00044281.JPEG', 'n03379051/ILSVRC2012_val_00019724.JPEG', 'n03379051/ILSVRC2012_val_00026706.JPEG', 'n03379051/ILSVRC2012_val_00029117.JPEG', 'n03379051/ILSVRC2012_val_00030467.JPEG', 'n03379051/ILSVRC2012_val_00034208.JPEG', 'n03424325/ILSVRC2012_val_00008355.JPEG', 'n03424325/ILSVRC2012_val_00009685.JPEG', 'n03424325/ILSVRC2012_val_00014992.JPEG', 'n03424325/ILSVRC2012_val_00047935.JPEG', 'n03492542/ILSVRC2012_val_00014717.JPEG', 'n03492542/ILSVRC2012_val_00016772.JPEG', 'n03492542/ILSVRC2012_val_00021902.JPEG', 'n03492542/ILSVRC2012_val_00023887.JPEG', 'n03492542/ILSVRC2012_val_00038096.JPEG', 'n03492542/ILSVRC2012_val_00040967.JPEG', 'n03494278/ILSVRC2012_val_00003436.JPEG', 'n03494278/ILSVRC2012_val_00015067.JPEG', 'n03494278/ILSVRC2012_val_00018926.JPEG', 'n03494278/ILSVRC2012_val_00028082.JPEG', 'n03494278/ILSVRC2012_val_00031028.JPEG', 'n03494278/ILSVRC2012_val_00035637.JPEG', 'n03530642/ILSVRC2012_val_00004681.JPEG', 'n03530642/ILSVRC2012_val_00007383.JPEG', 'n03530642/ILSVRC2012_val_00022030.JPEG', 'n03530642/ILSVRC2012_val_00025504.JPEG', 'n03530642/ILSVRC2012_val_00029028.JPEG', 'n03530642/ILSVRC2012_val_00034883.JPEG', 'n03530642/ILSVRC2012_val_00035870.JPEG', 'n03584829/ILSVRC2012_val_00025935.JPEG', 'n03594734/ILSVRC2012_val_00028663.JPEG', 'n03594734/ILSVRC2012_val_00031738.JPEG', 'n03594734/ILSVRC2012_val_00037472.JPEG', 'n03594734/ILSVRC2012_val_00039172.JPEG', 'n03594734/ILSVRC2012_val_00039574.JPEG', 'n03594734/ILSVRC2012_val_00047544.JPEG', 'n03637318/ILSVRC2012_val_00007656.JPEG', 'n03637318/ILSVRC2012_val_00010971.JPEG', 'n03637318/ILSVRC2012_val_00012139.JPEG', 'n03637318/ILSVRC2012_val_00017175.JPEG', 'n03637318/ILSVRC2012_val_00018590.JPEG', 'n03637318/ILSVRC2012_val_00026568.JPEG', 'n03637318/ILSVRC2012_val_00034586.JPEG', 'n03637318/ILSVRC2012_val_00046581.JPEG', 'n03637318/ILSVRC2012_val_00048879.JPEG', 'n03642806/ILSVRC2012_val_00000151.JPEG', 'n03642806/ILSVRC2012_val_00003142.JPEG', 'n03642806/ILSVRC2012_val_00018063.JPEG', 'n03642806/ILSVRC2012_val_00022093.JPEG', 'n03642806/ILSVRC2012_val_00022256.JPEG', 'n03642806/ILSVRC2012_val_00031574.JPEG', 'n03642806/ILSVRC2012_val_00038082.JPEG', 'n03642806/ILSVRC2012_val_00040665.JPEG', 'n03642806/ILSVRC2012_val_00042454.JPEG', 'n03764736/ILSVRC2012_val_00001522.JPEG', 'n03764736/ILSVRC2012_val_00001770.JPEG', 'n03764736/ILSVRC2012_val_00008765.JPEG', 'n03764736/ILSVRC2012_val_00010506.JPEG', 'n03764736/ILSVRC2012_val_00015009.JPEG', 'n03764736/ILSVRC2012_val_00018209.JPEG', 'n03764736/ILSVRC2012_val_00026080.JPEG', 'n03764736/ILSVRC2012_val_00027957.JPEG', 'n03764736/ILSVRC2012_val_00034439.JPEG', 'n03764736/ILSVRC2012_val_00047982.JPEG', 'n03775546/ILSVRC2012_val_00028444.JPEG', 'n03775546/ILSVRC2012_val_00032236.JPEG', 'n03775546/ILSVRC2012_val_00047849.JPEG', 'n03777754/ILSVRC2012_val_00008248.JPEG', 'n03777754/ILSVRC2012_val_00026631.JPEG', 'n03777754/ILSVRC2012_val_00033556.JPEG', 'n03777754/ILSVRC2012_val_00034423.JPEG', 'n03777754/ILSVRC2012_val_00038670.JPEG', 'n03777754/ILSVRC2012_val_00040760.JPEG', 'n03777754/ILSVRC2012_val_00044245.JPEG', 'n03785016/ILSVRC2012_val_00048082.JPEG', 'n03787032/ILSVRC2012_val_00024968.JPEG', 'n03794056/ILSVRC2012_val_00011238.JPEG', 'n03794056/ILSVRC2012_val_00045500.JPEG', 'n03837869/ILSVRC2012_val_00016301.JPEG', 'n03837869/ILSVRC2012_val_00017240.JPEG', 'n03837869/ILSVRC2012_val_00028939.JPEG', 'n03837869/ILSVRC2012_val_00046864.JPEG', 'n03891251/ILSVRC2012_val_00011880.JPEG', 'n03891251/ILSVRC2012_val_00019835.JPEG', 'n03903868/ILSVRC2012_val_00005983.JPEG', 'n03903868/ILSVRC2012_val_00021853.JPEG', 'n03903868/ILSVRC2012_val_00024631.JPEG', 'n03903868/ILSVRC2012_val_00034875.JPEG', 'n03903868/ILSVRC2012_val_00035124.JPEG', 'n03930630/ILSVRC2012_val_00007733.JPEG', 'n03930630/ILSVRC2012_val_00010907.JPEG', 'n03930630/ILSVRC2012_val_00017708.JPEG', 'n03930630/ILSVRC2012_val_00024317.JPEG', 'n03930630/ILSVRC2012_val_00029772.JPEG', 'n03930630/ILSVRC2012_val_00039120.JPEG', 'n03930630/ILSVRC2012_val_00039963.JPEG', 'n03947888/ILSVRC2012_val_00009856.JPEG', 'n03947888/ILSVRC2012_val_00036199.JPEG', 'n04026417/ILSVRC2012_val_00013522.JPEG', 'n04026417/ILSVRC2012_val_00013578.JPEG', 'n04026417/ILSVRC2012_val_00017058.JPEG', 'n04026417/ILSVRC2012_val_00017752.JPEG', 'n04026417/ILSVRC2012_val_00019537.JPEG', 'n04026417/ILSVRC2012_val_00019863.JPEG', 'n04026417/ILSVRC2012_val_00025944.JPEG', 'n04026417/ILSVRC2012_val_00030487.JPEG', 'n04067472/ILSVRC2012_val_00002556.JPEG', 'n04067472/ILSVRC2012_val_00012789.JPEG', 'n04067472/ILSVRC2012_val_00028684.JPEG', 'n04067472/ILSVRC2012_val_00034956.JPEG', 'n04099969/ILSVRC2012_val_00008768.JPEG', 'n04099969/ILSVRC2012_val_00009659.JPEG', 'n04099969/ILSVRC2012_val_00013777.JPEG', 'n04099969/ILSVRC2012_val_00025634.JPEG', 'n04099969/ILSVRC2012_val_00048622.JPEG', 'n04111531/ILSVRC2012_val_00045813.JPEG', 'n04127249/ILSVRC2012_val_00016361.JPEG', 'n04127249/ILSVRC2012_val_00016436.JPEG', 'n04127249/ILSVRC2012_val_00023036.JPEG', 'n04127249/ILSVRC2012_val_00024308.JPEG', 'n04127249/ILSVRC2012_val_00025670.JPEG', 'n04127249/ILSVRC2012_val_00036087.JPEG', 'n04127249/ILSVRC2012_val_00041228.JPEG', 'n04136333/ILSVRC2012_val_00013068.JPEG', 'n04136333/ILSVRC2012_val_00019371.JPEG', 'n04136333/ILSVRC2012_val_00022316.JPEG', 'n04136333/ILSVRC2012_val_00028430.JPEG', 'n04136333/ILSVRC2012_val_00032121.JPEG', 'n04136333/ILSVRC2012_val_00033983.JPEG', 'n04136333/ILSVRC2012_val_00044155.JPEG', 'n04136333/ILSVRC2012_val_00047782.JPEG', 'n04229816/ILSVRC2012_val_00009290.JPEG', 'n04229816/ILSVRC2012_val_00012859.JPEG', 'n04229816/ILSVRC2012_val_00015621.JPEG', 'n04229816/ILSVRC2012_val_00018711.JPEG', 'n04229816/ILSVRC2012_val_00020818.JPEG', 'n04229816/ILSVRC2012_val_00035299.JPEG', 'n04229816/ILSVRC2012_val_00043826.JPEG', 'n04229816/ILSVRC2012_val_00047467.JPEG', 'n04238763/ILSVRC2012_val_00001599.JPEG', 'n04238763/ILSVRC2012_val_00014178.JPEG', 'n04238763/ILSVRC2012_val_00026669.JPEG', 'n04238763/ILSVRC2012_val_00049850.JPEG', 'n04336792/ILSVRC2012_val_00016751.JPEG', 'n04336792/ILSVRC2012_val_00026841.JPEG', 'n04336792/ILSVRC2012_val_00028123.JPEG', 'n04336792/ILSVRC2012_val_00037415.JPEG', 'n04336792/ILSVRC2012_val_00044134.JPEG', 'n04418357/ILSVRC2012_val_00007909.JPEG', 'n04418357/ILSVRC2012_val_00019376.JPEG', 'n04418357/ILSVRC2012_val_00034027.JPEG', 'n04418357/ILSVRC2012_val_00041249.JPEG', 'n04418357/ILSVRC2012_val_00049138.JPEG', 'n04429376/ILSVRC2012_val_00001160.JPEG', 'n04429376/ILSVRC2012_val_00003519.JPEG', 'n04429376/ILSVRC2012_val_00013539.JPEG', 'n04429376/ILSVRC2012_val_00025374.JPEG', 'n04429376/ILSVRC2012_val_00041720.JPEG', 'n04435653/ILSVRC2012_val_00022779.JPEG', 'n04435653/ILSVRC2012_val_00027447.JPEG', 'n04435653/ILSVRC2012_val_00044409.JPEG', 'n04485082/ILSVRC2012_val_00001409.JPEG', 'n04485082/ILSVRC2012_val_00009669.JPEG', 'n04485082/ILSVRC2012_val_00017603.JPEG', 'n04485082/ILSVRC2012_val_00036032.JPEG', 'n04493381/ILSVRC2012_val_00009864.JPEG', 'n04493381/ILSVRC2012_val_00012077.JPEG', 'n04493381/ILSVRC2012_val_00026655.JPEG', 'n04493381/ILSVRC2012_val_00039442.JPEG', 'n04517823/ILSVRC2012_val_00004252.JPEG', 'n04517823/ILSVRC2012_val_00018100.JPEG', 'n04517823/ILSVRC2012_val_00020843.JPEG', 'n04517823/ILSVRC2012_val_00025993.JPEG', 'n04517823/ILSVRC2012_val_00036519.JPEG', 'n04517823/ILSVRC2012_val_00037540.JPEG', 'n04589890/ILSVRC2012_val_00002310.JPEG', 'n04589890/ILSVRC2012_val_00010471.JPEG', 'n04589890/ILSVRC2012_val_00011390.JPEG', 'n04589890/ILSVRC2012_val_00028748.JPEG', 'n04589890/ILSVRC2012_val_00030215.JPEG', 'n04589890/ILSVRC2012_val_00030954.JPEG', 'n04589890/ILSVRC2012_val_00033500.JPEG', 'n04592741/ILSVRC2012_val_00018330.JPEG', 'n07714571/ILSVRC2012_val_00039050.JPEG', 'n07714571/ILSVRC2012_val_00043273.JPEG', 'n07715103/ILSVRC2012_val_00020636.JPEG', 'n07715103/ILSVRC2012_val_00031499.JPEG', 'n07753275/ILSVRC2012_val_00003549.JPEG', 'n07753275/ILSVRC2012_val_00020751.JPEG', 'n07753275/ILSVRC2012_val_00035283.JPEG', 'n07831146/ILSVRC2012_val_00004837.JPEG', 'n07831146/ILSVRC2012_val_00019588.JPEG', 'n07831146/ILSVRC2012_val_00035071.JPEG', 'n07831146/ILSVRC2012_val_00036499.JPEG', 'n07836838/ILSVRC2012_val_00007307.JPEG', 'n07836838/ILSVRC2012_val_00014400.JPEG', 'n07836838/ILSVRC2012_val_00024526.JPEG', 'n07836838/ILSVRC2012_val_00043225.JPEG', 'n13037406/ILSVRC2012_val_00024832.JPEG', 'n13037406/ILSVRC2012_val_00043934.JPEG', 'n13040303/ILSVRC2012_val_00045228.JPEG']
    # wrong_list_two_loss = ['n01692333/ILSVRC2012_val_00005227.JPEG', 'n01692333/ILSVRC2012_val_00010164.JPEG', 'n01692333/ILSVRC2012_val_00014312.JPEG', 'n01692333/ILSVRC2012_val_00041887.JPEG', 'n01729322/ILSVRC2012_val_00002568.JPEG', 'n01729322/ILSVRC2012_val_00003098.JPEG', 'n01729322/ILSVRC2012_val_00013117.JPEG', 'n01729322/ILSVRC2012_val_00017346.JPEG', 'n01729322/ILSVRC2012_val_00024259.JPEG', 'n01729322/ILSVRC2012_val_00037553.JPEG', 'n01729322/ILSVRC2012_val_00039530.JPEG', 'n01735189/ILSVRC2012_val_00023442.JPEG', 'n01749939/ILSVRC2012_val_00006403.JPEG', 'n01749939/ILSVRC2012_val_00014252.JPEG', 'n01749939/ILSVRC2012_val_00014575.JPEG', 'n01749939/ILSVRC2012_val_00026739.JPEG', 'n01749939/ILSVRC2012_val_00030360.JPEG', 'n01773797/ILSVRC2012_val_00001987.JPEG', 'n01773797/ILSVRC2012_val_00036109.JPEG', 'n01773797/ILSVRC2012_val_00043646.JPEG', 'n01855672/ILSVRC2012_val_00016490.JPEG', 'n01855672/ILSVRC2012_val_00030245.JPEG', 'n01978455/ILSVRC2012_val_00004254.JPEG', 'n01978455/ILSVRC2012_val_00009697.JPEG', 'n01978455/ILSVRC2012_val_00013377.JPEG', 'n01978455/ILSVRC2012_val_00019859.JPEG', 'n01978455/ILSVRC2012_val_00023604.JPEG', 'n01978455/ILSVRC2012_val_00023840.JPEG', 'n01978455/ILSVRC2012_val_00029812.JPEG', 'n01980166/ILSVRC2012_val_00000818.JPEG', 'n01980166/ILSVRC2012_val_00007370.JPEG', 'n01980166/ILSVRC2012_val_00010555.JPEG', 'n01980166/ILSVRC2012_val_00012779.JPEG', 'n01980166/ILSVRC2012_val_00013999.JPEG', 'n01980166/ILSVRC2012_val_00015319.JPEG', 'n01980166/ILSVRC2012_val_00016554.JPEG', 'n01980166/ILSVRC2012_val_00020779.JPEG', 'n01980166/ILSVRC2012_val_00023339.JPEG', 'n01980166/ILSVRC2012_val_00030408.JPEG', 'n01980166/ILSVRC2012_val_00032547.JPEG', 'n01980166/ILSVRC2012_val_00035169.JPEG', 'n01980166/ILSVRC2012_val_00035361.JPEG', 'n01980166/ILSVRC2012_val_00038232.JPEG', 'n01980166/ILSVRC2012_val_00047880.JPEG', 'n02009229/ILSVRC2012_val_00025744.JPEG', 'n02018207/ILSVRC2012_val_00001165.JPEG', 'n02018207/ILSVRC2012_val_00014805.JPEG', 'n02018207/ILSVRC2012_val_00034172.JPEG', 'n02085620/ILSVRC2012_val_00006079.JPEG', 'n02085620/ILSVRC2012_val_00014409.JPEG', 'n02085620/ILSVRC2012_val_00016688.JPEG', 'n02085620/ILSVRC2012_val_00017702.JPEG', 'n02085620/ILSVRC2012_val_00018882.JPEG', 'n02085620/ILSVRC2012_val_00020016.JPEG', 'n02085620/ILSVRC2012_val_00024590.JPEG', 'n02085620/ILSVRC2012_val_00027452.JPEG', 'n02085620/ILSVRC2012_val_00028943.JPEG', 'n02085620/ILSVRC2012_val_00029289.JPEG', 'n02085620/ILSVRC2012_val_00029450.JPEG', 'n02085620/ILSVRC2012_val_00037791.JPEG', 'n02085620/ILSVRC2012_val_00049159.JPEG', 'n02086240/ILSVRC2012_val_00015738.JPEG', 'n02086240/ILSVRC2012_val_00035293.JPEG', 'n02086910/ILSVRC2012_val_00022099.JPEG', 'n02086910/ILSVRC2012_val_00024758.JPEG', 'n02087046/ILSVRC2012_val_00001371.JPEG', 'n02087046/ILSVRC2012_val_00002521.JPEG', 'n02087046/ILSVRC2012_val_00004325.JPEG', 'n02087046/ILSVRC2012_val_00006544.JPEG', 'n02087046/ILSVRC2012_val_00007511.JPEG', 'n02087046/ILSVRC2012_val_00011748.JPEG', 'n02087046/ILSVRC2012_val_00019566.JPEG', 'n02087046/ILSVRC2012_val_00036751.JPEG', 'n02087046/ILSVRC2012_val_00037669.JPEG', 'n02087046/ILSVRC2012_val_00041444.JPEG', 'n02087046/ILSVRC2012_val_00044441.JPEG', 'n02089867/ILSVRC2012_val_00004777.JPEG', 'n02089867/ILSVRC2012_val_00005831.JPEG', 'n02089867/ILSVRC2012_val_00010950.JPEG', 'n02089867/ILSVRC2012_val_00014045.JPEG', 'n02089867/ILSVRC2012_val_00022913.JPEG', 'n02089867/ILSVRC2012_val_00042394.JPEG', 'n02089973/ILSVRC2012_val_00001696.JPEG', 'n02089973/ILSVRC2012_val_00001777.JPEG', 'n02089973/ILSVRC2012_val_00010168.JPEG', 'n02089973/ILSVRC2012_val_00011342.JPEG', 'n02089973/ILSVRC2012_val_00012875.JPEG', 'n02089973/ILSVRC2012_val_00025914.JPEG', 'n02089973/ILSVRC2012_val_00029164.JPEG', 'n02089973/ILSVRC2012_val_00031859.JPEG', 'n02089973/ILSVRC2012_val_00033378.JPEG', 'n02089973/ILSVRC2012_val_00033633.JPEG', 'n02089973/ILSVRC2012_val_00033666.JPEG', 'n02089973/ILSVRC2012_val_00033862.JPEG', 'n02089973/ILSVRC2012_val_00034690.JPEG', 'n02089973/ILSVRC2012_val_00036191.JPEG', 'n02089973/ILSVRC2012_val_00037826.JPEG', 'n02089973/ILSVRC2012_val_00040069.JPEG', 'n02089973/ILSVRC2012_val_00043341.JPEG', 'n02089973/ILSVRC2012_val_00043580.JPEG', 'n02089973/ILSVRC2012_val_00043610.JPEG', 'n02089973/ILSVRC2012_val_00045799.JPEG', 'n02089973/ILSVRC2012_val_00046454.JPEG', 'n02089973/ILSVRC2012_val_00048188.JPEG', 'n02089973/ILSVRC2012_val_00049640.JPEG', 'n02090622/ILSVRC2012_val_00018654.JPEG', 'n02090622/ILSVRC2012_val_00021450.JPEG', 'n02091831/ILSVRC2012_val_00005217.JPEG', 'n02091831/ILSVRC2012_val_00027267.JPEG', 'n02091831/ILSVRC2012_val_00027810.JPEG', 'n02091831/ILSVRC2012_val_00030249.JPEG', 'n02091831/ILSVRC2012_val_00045441.JPEG', 'n02093428/ILSVRC2012_val_00011387.JPEG', 'n02093428/ILSVRC2012_val_00021754.JPEG', 'n02093428/ILSVRC2012_val_00029242.JPEG', 'n02093428/ILSVRC2012_val_00035793.JPEG', 'n02093428/ILSVRC2012_val_00039832.JPEG', 'n02093428/ILSVRC2012_val_00045238.JPEG', 'n02093428/ILSVRC2012_val_00045763.JPEG', 'n02099849/ILSVRC2012_val_00038026.JPEG', 'n02099849/ILSVRC2012_val_00042838.JPEG', 'n02100583/ILSVRC2012_val_00005923.JPEG', 'n02100583/ILSVRC2012_val_00013971.JPEG', 'n02100583/ILSVRC2012_val_00018982.JPEG', 'n02100583/ILSVRC2012_val_00026854.JPEG', 'n02100583/ILSVRC2012_val_00038738.JPEG', 'n02100583/ILSVRC2012_val_00040937.JPEG', 'n02100583/ILSVRC2012_val_00045544.JPEG', 'n02100583/ILSVRC2012_val_00049139.JPEG', 'n02104029/ILSVRC2012_val_00005583.JPEG', 'n02104029/ILSVRC2012_val_00020132.JPEG', 'n02104029/ILSVRC2012_val_00024981.JPEG', 'n02104029/ILSVRC2012_val_00035377.JPEG', 'n02105505/ILSVRC2012_val_00003575.JPEG', 'n02105505/ILSVRC2012_val_00007059.JPEG', 'n02105505/ILSVRC2012_val_00007246.JPEG', 'n02105505/ILSVRC2012_val_00027643.JPEG', 'n02105505/ILSVRC2012_val_00032099.JPEG', 'n02105505/ILSVRC2012_val_00048075.JPEG', 'n02106550/ILSVRC2012_val_00026005.JPEG', 'n02106550/ILSVRC2012_val_00026388.JPEG', 'n02106550/ILSVRC2012_val_00039235.JPEG', 'n02107142/ILSVRC2012_val_00000134.JPEG', 'n02107142/ILSVRC2012_val_00008343.JPEG', 'n02107142/ILSVRC2012_val_00013297.JPEG', 'n02107142/ILSVRC2012_val_00022474.JPEG', 'n02107142/ILSVRC2012_val_00030370.JPEG', 'n02107142/ILSVRC2012_val_00036045.JPEG', 'n02107142/ILSVRC2012_val_00041795.JPEG', 'n02107142/ILSVRC2012_val_00047822.JPEG', 'n02108089/ILSVRC2012_val_00005495.JPEG', 'n02108089/ILSVRC2012_val_00007001.JPEG', 'n02108089/ILSVRC2012_val_00009189.JPEG', 'n02108089/ILSVRC2012_val_00009553.JPEG', 'n02108089/ILSVRC2012_val_00014721.JPEG', 'n02108089/ILSVRC2012_val_00016857.JPEG', 'n02108089/ILSVRC2012_val_00017602.JPEG', 'n02108089/ILSVRC2012_val_00024675.JPEG', 'n02108089/ILSVRC2012_val_00029970.JPEG', 'n02108089/ILSVRC2012_val_00032406.JPEG', 'n02108089/ILSVRC2012_val_00035275.JPEG', 'n02108089/ILSVRC2012_val_00045933.JPEG', 'n02108089/ILSVRC2012_val_00049040.JPEG', 'n02109047/ILSVRC2012_val_00001408.JPEG', 'n02109047/ILSVRC2012_val_00003069.JPEG', 'n02109047/ILSVRC2012_val_00006834.JPEG', 'n02109047/ILSVRC2012_val_00007915.JPEG', 'n02109047/ILSVRC2012_val_00013475.JPEG', 'n02109047/ILSVRC2012_val_00017636.JPEG', 'n02109047/ILSVRC2012_val_00022808.JPEG', 'n02109047/ILSVRC2012_val_00022814.JPEG', 'n02109047/ILSVRC2012_val_00023076.JPEG', 'n02109047/ILSVRC2012_val_00024587.JPEG', 'n02109047/ILSVRC2012_val_00032160.JPEG', 'n02109047/ILSVRC2012_val_00034748.JPEG', 'n02109047/ILSVRC2012_val_00035579.JPEG', 'n02109047/ILSVRC2012_val_00036235.JPEG', 'n02109047/ILSVRC2012_val_00043452.JPEG', 'n02109047/ILSVRC2012_val_00047250.JPEG', 'n02109047/ILSVRC2012_val_00048145.JPEG', 'n02113799/ILSVRC2012_val_00007866.JPEG', 'n02113978/ILSVRC2012_val_00001467.JPEG', 'n02113978/ILSVRC2012_val_00008137.JPEG', 'n02113978/ILSVRC2012_val_00033581.JPEG', 'n02113978/ILSVRC2012_val_00044767.JPEG', 'n02114855/ILSVRC2012_val_00000156.JPEG', 'n02114855/ILSVRC2012_val_00003765.JPEG', 'n02114855/ILSVRC2012_val_00004540.JPEG', 'n02114855/ILSVRC2012_val_00017231.JPEG', 'n02114855/ILSVRC2012_val_00044732.JPEG', 'n02119022/ILSVRC2012_val_00004141.JPEG', 'n02119022/ILSVRC2012_val_00009066.JPEG', 'n02119022/ILSVRC2012_val_00010552.JPEG', 'n02119022/ILSVRC2012_val_00020790.JPEG', 'n02119022/ILSVRC2012_val_00027828.JPEG', 'n02119022/ILSVRC2012_val_00029361.JPEG', 'n02119022/ILSVRC2012_val_00047690.JPEG', 'n02123045/ILSVRC2012_val_00001341.JPEG', 'n02123045/ILSVRC2012_val_00030706.JPEG', 'n02123045/ILSVRC2012_val_00047911.JPEG', 'n02172182/ILSVRC2012_val_00020308.JPEG', 'n02172182/ILSVRC2012_val_00040267.JPEG', 'n02231487/ILSVRC2012_val_00003586.JPEG', 'n02231487/ILSVRC2012_val_00035534.JPEG', 'n02231487/ILSVRC2012_val_00047601.JPEG', 'n02259212/ILSVRC2012_val_00040451.JPEG', 'n02483362/ILSVRC2012_val_00027489.JPEG', 'n02483362/ILSVRC2012_val_00038037.JPEG', 'n02483362/ILSVRC2012_val_00045321.JPEG', 'n02488291/ILSVRC2012_val_00009359.JPEG', 'n02488291/ILSVRC2012_val_00031939.JPEG', 'n02488291/ILSVRC2012_val_00038601.JPEG', 'n02488291/ILSVRC2012_val_00039767.JPEG', 'n02488291/ILSVRC2012_val_00041180.JPEG', 'n02488291/ILSVRC2012_val_00046153.JPEG', 'n02488291/ILSVRC2012_val_00046873.JPEG', 'n02701002/ILSVRC2012_val_00049302.JPEG', 'n02788148/ILSVRC2012_val_00039546.JPEG', 'n02804414/ILSVRC2012_val_00017317.JPEG', 'n02804414/ILSVRC2012_val_00023622.JPEG', 'n02869837/ILSVRC2012_val_00005523.JPEG', 'n02869837/ILSVRC2012_val_00013039.JPEG', 'n02869837/ILSVRC2012_val_00015589.JPEG', 'n02869837/ILSVRC2012_val_00022447.JPEG', 'n02869837/ILSVRC2012_val_00030536.JPEG', 'n02869837/ILSVRC2012_val_00031092.JPEG', 'n02869837/ILSVRC2012_val_00038967.JPEG', 'n02869837/ILSVRC2012_val_00040107.JPEG', 'n02869837/ILSVRC2012_val_00048571.JPEG', 'n02877765/ILSVRC2012_val_00012104.JPEG', 'n02877765/ILSVRC2012_val_00022892.JPEG', 'n02877765/ILSVRC2012_val_00028640.JPEG', 'n02877765/ILSVRC2012_val_00032877.JPEG', 'n02974003/ILSVRC2012_val_00000085.JPEG', 'n02974003/ILSVRC2012_val_00001861.JPEG', 'n02974003/ILSVRC2012_val_00011981.JPEG', 'n02974003/ILSVRC2012_val_00017438.JPEG', 'n02974003/ILSVRC2012_val_00042653.JPEG', 'n03017168/ILSVRC2012_val_00004502.JPEG', 'n03017168/ILSVRC2012_val_00026501.JPEG', 'n03017168/ILSVRC2012_val_00028741.JPEG', 'n03017168/ILSVRC2012_val_00031125.JPEG', 'n03017168/ILSVRC2012_val_00035306.JPEG', 'n03017168/ILSVRC2012_val_00047514.JPEG', 'n03032252/ILSVRC2012_val_00001894.JPEG', 'n03032252/ILSVRC2012_val_00015013.JPEG', 'n03032252/ILSVRC2012_val_00024311.JPEG', 'n03032252/ILSVRC2012_val_00026473.JPEG', 'n03032252/ILSVRC2012_val_00030652.JPEG', 'n03032252/ILSVRC2012_val_00030890.JPEG', 'n03032252/ILSVRC2012_val_00034561.JPEG', 'n03032252/ILSVRC2012_val_00040393.JPEG', 'n03032252/ILSVRC2012_val_00040566.JPEG', 'n03032252/ILSVRC2012_val_00041963.JPEG', 'n03062245/ILSVRC2012_val_00002666.JPEG', 'n03062245/ILSVRC2012_val_00034375.JPEG', 'n03062245/ILSVRC2012_val_00040906.JPEG', 'n03085013/ILSVRC2012_val_00012334.JPEG', 'n03085013/ILSVRC2012_val_00032810.JPEG', 'n03085013/ILSVRC2012_val_00041349.JPEG', 'n03085013/ILSVRC2012_val_00048307.JPEG', 'n03259280/ILSVRC2012_val_00018603.JPEG', 'n03259280/ILSVRC2012_val_00026342.JPEG', 'n03259280/ILSVRC2012_val_00035498.JPEG', 'n03259280/ILSVRC2012_val_00043855.JPEG', 'n03259280/ILSVRC2012_val_00044281.JPEG', 'n03259280/ILSVRC2012_val_00048045.JPEG', 'n03379051/ILSVRC2012_val_00026706.JPEG', 'n03379051/ILSVRC2012_val_00029117.JPEG', 'n03424325/ILSVRC2012_val_00008355.JPEG', 'n03424325/ILSVRC2012_val_00014992.JPEG', 'n03424325/ILSVRC2012_val_00047935.JPEG', 'n03492542/ILSVRC2012_val_00011209.JPEG', 'n03492542/ILSVRC2012_val_00016772.JPEG', 'n03492542/ILSVRC2012_val_00021902.JPEG', 'n03492542/ILSVRC2012_val_00023887.JPEG', 'n03492542/ILSVRC2012_val_00038096.JPEG', 'n03492542/ILSVRC2012_val_00040967.JPEG', 'n03494278/ILSVRC2012_val_00028082.JPEG', 'n03530642/ILSVRC2012_val_00007383.JPEG', 'n03530642/ILSVRC2012_val_00017838.JPEG', 'n03530642/ILSVRC2012_val_00022030.JPEG', 'n03530642/ILSVRC2012_val_00025146.JPEG', 'n03530642/ILSVRC2012_val_00029028.JPEG', 'n03530642/ILSVRC2012_val_00034883.JPEG', 'n03530642/ILSVRC2012_val_00042170.JPEG', 'n03584829/ILSVRC2012_val_00007158.JPEG', 'n03584829/ILSVRC2012_val_00026533.JPEG', 'n03584829/ILSVRC2012_val_00037977.JPEG', 'n03584829/ILSVRC2012_val_00047027.JPEG', 'n03584829/ILSVRC2012_val_00049140.JPEG', 'n03594734/ILSVRC2012_val_00031738.JPEG', 'n03594734/ILSVRC2012_val_00037472.JPEG', 'n03594734/ILSVRC2012_val_00039172.JPEG', 'n03594734/ILSVRC2012_val_00042356.JPEG', 'n03637318/ILSVRC2012_val_00007656.JPEG', 'n03637318/ILSVRC2012_val_00010971.JPEG', 'n03637318/ILSVRC2012_val_00012139.JPEG', 'n03637318/ILSVRC2012_val_00034586.JPEG', 'n03637318/ILSVRC2012_val_00046581.JPEG', 'n03637318/ILSVRC2012_val_00048879.JPEG', 'n03642806/ILSVRC2012_val_00003142.JPEG', 'n03642806/ILSVRC2012_val_00005275.JPEG', 'n03642806/ILSVRC2012_val_00005940.JPEG', 'n03642806/ILSVRC2012_val_00011275.JPEG', 'n03642806/ILSVRC2012_val_00018063.JPEG', 'n03642806/ILSVRC2012_val_00021447.JPEG', 'n03642806/ILSVRC2012_val_00022093.JPEG', 'n03642806/ILSVRC2012_val_00031843.JPEG', 'n03642806/ILSVRC2012_val_00040665.JPEG', 'n03764736/ILSVRC2012_val_00001522.JPEG', 'n03764736/ILSVRC2012_val_00006557.JPEG', 'n03764736/ILSVRC2012_val_00008765.JPEG', 'n03764736/ILSVRC2012_val_00010506.JPEG', 'n03764736/ILSVRC2012_val_00013680.JPEG', 'n03764736/ILSVRC2012_val_00015009.JPEG', 'n03764736/ILSVRC2012_val_00021194.JPEG', 'n03764736/ILSVRC2012_val_00022235.JPEG', 'n03764736/ILSVRC2012_val_00027957.JPEG', 'n03764736/ILSVRC2012_val_00034439.JPEG', 'n03775546/ILSVRC2012_val_00047849.JPEG', 'n03777754/ILSVRC2012_val_00003373.JPEG', 'n03777754/ILSVRC2012_val_00033556.JPEG', 'n03777754/ILSVRC2012_val_00034423.JPEG', 'n03777754/ILSVRC2012_val_00038670.JPEG', 'n03777754/ILSVRC2012_val_00040760.JPEG', 'n03777754/ILSVRC2012_val_00044245.JPEG', 'n03785016/ILSVRC2012_val_00048082.JPEG', 'n03787032/ILSVRC2012_val_00034131.JPEG', 'n03794056/ILSVRC2012_val_00011238.JPEG', 'n03794056/ILSVRC2012_val_00047199.JPEG', 'n03837869/ILSVRC2012_val_00011566.JPEG', 'n03837869/ILSVRC2012_val_00016301.JPEG', 'n03891251/ILSVRC2012_val_00011880.JPEG', 'n03891251/ILSVRC2012_val_00019835.JPEG', 'n03891251/ILSVRC2012_val_00021662.JPEG', 'n03891251/ILSVRC2012_val_00027250.JPEG', 'n03891251/ILSVRC2012_val_00029949.JPEG', 'n03903868/ILSVRC2012_val_00005983.JPEG', 'n03903868/ILSVRC2012_val_00009123.JPEG', 'n03903868/ILSVRC2012_val_00021853.JPEG', 'n03903868/ILSVRC2012_val_00030317.JPEG', 'n03903868/ILSVRC2012_val_00034875.JPEG', 'n03903868/ILSVRC2012_val_00035124.JPEG', 'n03903868/ILSVRC2012_val_00046282.JPEG', 'n03930630/ILSVRC2012_val_00007733.JPEG', 'n03930630/ILSVRC2012_val_00010907.JPEG', 'n03930630/ILSVRC2012_val_00015879.JPEG', 'n03930630/ILSVRC2012_val_00017708.JPEG', 'n03930630/ILSVRC2012_val_00022918.JPEG', 'n03930630/ILSVRC2012_val_00026079.JPEG', 'n03930630/ILSVRC2012_val_00029772.JPEG', 'n03930630/ILSVRC2012_val_00039120.JPEG', 'n03930630/ILSVRC2012_val_00039963.JPEG', 'n03947888/ILSVRC2012_val_00009856.JPEG', 'n03947888/ILSVRC2012_val_00036199.JPEG', 'n04026417/ILSVRC2012_val_00001565.JPEG', 'n04026417/ILSVRC2012_val_00002268.JPEG', 'n04026417/ILSVRC2012_val_00019537.JPEG', 'n04026417/ILSVRC2012_val_00019863.JPEG', 'n04026417/ILSVRC2012_val_00030487.JPEG', 'n04067472/ILSVRC2012_val_00002556.JPEG', 'n04067472/ILSVRC2012_val_00012789.JPEG', 'n04067472/ILSVRC2012_val_00028684.JPEG', 'n04067472/ILSVRC2012_val_00034956.JPEG', 'n04067472/ILSVRC2012_val_00044147.JPEG', 'n04099969/ILSVRC2012_val_00008768.JPEG', 'n04099969/ILSVRC2012_val_00009659.JPEG', 'n04099969/ILSVRC2012_val_00048622.JPEG', 'n04111531/ILSVRC2012_val_00045813.JPEG', 'n04127249/ILSVRC2012_val_00004233.JPEG', 'n04127249/ILSVRC2012_val_00016361.JPEG', 'n04127249/ILSVRC2012_val_00023036.JPEG', 'n04127249/ILSVRC2012_val_00024308.JPEG', 'n04127249/ILSVRC2012_val_00025670.JPEG', 'n04127249/ILSVRC2012_val_00036087.JPEG', 'n04136333/ILSVRC2012_val_00002902.JPEG', 'n04136333/ILSVRC2012_val_00022316.JPEG', 'n04136333/ILSVRC2012_val_00030084.JPEG', 'n04136333/ILSVRC2012_val_00032121.JPEG', 'n04136333/ILSVRC2012_val_00033983.JPEG', 'n04136333/ILSVRC2012_val_00044155.JPEG', 'n04229816/ILSVRC2012_val_00009290.JPEG', 'n04229816/ILSVRC2012_val_00012859.JPEG', 'n04229816/ILSVRC2012_val_00018711.JPEG', 'n04229816/ILSVRC2012_val_00035299.JPEG', 'n04238763/ILSVRC2012_val_00001599.JPEG', 'n04238763/ILSVRC2012_val_00014178.JPEG', 'n04238763/ILSVRC2012_val_00024829.JPEG', 'n04238763/ILSVRC2012_val_00029103.JPEG', 'n04238763/ILSVRC2012_val_00049850.JPEG', 'n04336792/ILSVRC2012_val_00004166.JPEG', 'n04336792/ILSVRC2012_val_00009356.JPEG', 'n04336792/ILSVRC2012_val_00027884.JPEG', 'n04336792/ILSVRC2012_val_00028123.JPEG', 'n04336792/ILSVRC2012_val_00037415.JPEG', 'n04336792/ILSVRC2012_val_00044134.JPEG', 'n04418357/ILSVRC2012_val_00011972.JPEG', 'n04418357/ILSVRC2012_val_00016570.JPEG', 'n04418357/ILSVRC2012_val_00034027.JPEG', 'n04418357/ILSVRC2012_val_00041249.JPEG', 'n04418357/ILSVRC2012_val_00049138.JPEG', 'n04429376/ILSVRC2012_val_00001160.JPEG', 'n04429376/ILSVRC2012_val_00013539.JPEG', 'n04429376/ILSVRC2012_val_00017455.JPEG', 'n04429376/ILSVRC2012_val_00025374.JPEG', 'n04435653/ILSVRC2012_val_00021105.JPEG', 'n04435653/ILSVRC2012_val_00022779.JPEG', 'n04435653/ILSVRC2012_val_00027447.JPEG', 'n04435653/ILSVRC2012_val_00034111.JPEG', 'n04435653/ILSVRC2012_val_00044409.JPEG', 'n04485082/ILSVRC2012_val_00009669.JPEG', 'n04493381/ILSVRC2012_val_00012077.JPEG', 'n04493381/ILSVRC2012_val_00014421.JPEG', 'n04493381/ILSVRC2012_val_00018795.JPEG', 'n04493381/ILSVRC2012_val_00025823.JPEG', 'n04517823/ILSVRC2012_val_00012535.JPEG', 'n04517823/ILSVRC2012_val_00018100.JPEG', 'n04517823/ILSVRC2012_val_00025595.JPEG', 'n04517823/ILSVRC2012_val_00025993.JPEG', 'n04517823/ILSVRC2012_val_00036519.JPEG', 'n04517823/ILSVRC2012_val_00037540.JPEG', 'n04589890/ILSVRC2012_val_00000351.JPEG', 'n04589890/ILSVRC2012_val_00010471.JPEG', 'n04589890/ILSVRC2012_val_00011390.JPEG', 'n04589890/ILSVRC2012_val_00013291.JPEG', 'n04589890/ILSVRC2012_val_00018029.JPEG', 'n04589890/ILSVRC2012_val_00028748.JPEG', 'n04589890/ILSVRC2012_val_00030215.JPEG', 'n04589890/ILSVRC2012_val_00030954.JPEG', 'n04589890/ILSVRC2012_val_00033500.JPEG', 'n04592741/ILSVRC2012_val_00018330.JPEG', 'n07714571/ILSVRC2012_val_00002925.JPEG', 'n07714571/ILSVRC2012_val_00004936.JPEG', 'n07714571/ILSVRC2012_val_00039050.JPEG', 'n07714571/ILSVRC2012_val_00043273.JPEG', 'n07715103/ILSVRC2012_val_00012240.JPEG', 'n07715103/ILSVRC2012_val_00031499.JPEG', 'n07715103/ILSVRC2012_val_00039501.JPEG', 'n07753275/ILSVRC2012_val_00003549.JPEG', 'n07753275/ILSVRC2012_val_00020751.JPEG', 'n07753275/ILSVRC2012_val_00035283.JPEG', 'n07831146/ILSVRC2012_val_00019588.JPEG', 'n07836838/ILSVRC2012_val_00007307.JPEG', 'n07836838/ILSVRC2012_val_00014400.JPEG', 'n07836838/ILSVRC2012_val_00034148.JPEG', 'n07836838/ILSVRC2012_val_00043225.JPEG', 'n07836838/ILSVRC2012_val_00043992.JPEG', 'n13037406/ILSVRC2012_val_00043934.JPEG', 'n13040303/ILSVRC2012_val_00000967.JPEG', 'n13040303/ILSVRC2012_val_00045228.JPEG']

    # baseline: wrong pg-0.7118; wrong epg-0.4023
    # three loss: wrong pg-0.8112; wrong epg-0.4556
    # two loss: wrong pg-0.7472; wrong epg-0.4727

    # file_path = 'search_result/l16_224/result_baseline.csv'  # Point Game: 0.8244  Energy Point Game: 0.550820581644562
    file_path = 'search_result/l16_224/result_cgc.csv'  #  Point Game: 0.8278  Energy Point Game: 0.5337514709454723
    # file_path = 'search_result/l16_224/result_reg.csv'  # Point Game: 0.8944  Energy Point Game: 0.6021727952302043
    # file_path = 'search_result/l16_224/result_two_loss.csv'  # Point Game: 0.8386  Energy Point Game: 0.6134799580441337

    file_path = 'search_result/conf+cons-epoch10-lambda0.5-reg_freq20/result.csv'

    result = read_csv_to_dict(file_path)


    file_path_consistency = 'search_result/-cons-epoch10-lambda0.5-reg_freq20/consistency_score_full.csv'
    result_baseline_consistency = read_csv_to_dict(file_path_consistency, 'float')


    pg_value = []
    pg_energy_value = []

    for image_path in tqdm(result.keys()):
        # for image_path in tqdm(wrong_list_baseline):
        ann_path = 'ImageNet100/val_annotation/' + image_path.replace('.JPEG', '.xml')


        # index = find_first_above_threshold(result_baseline_consistency[image_path.split('/')[-1]])
        # result_list = result[image_path][:index+1]
        # attribution_map_pg = patches_tensor[result_list[0]].squeeze()
        # attribution_map_epg = patches_tensor[result_list].sum(0).squeeze()


        attribution_map_pg = patches_tensor[result[image_path][0]].squeeze()
        attribution_map_epg = patches_tensor[result[image_path]].sum(0).squeeze()
        ann = parse_xml(ann_path)
        bbox = [a['bbox'] for a in ann]


        # attribution_map = cv2.resize(attribution_map, (h, w))
        # attribution_map = cv2.transpose(attribution_map)
        # image = cv2.imread(image_path)
        # heatmap = cv2.applyColorMap(np.uint8(attribution_map*255), cv2.COLORMAP_COOL)  # cv2.COLORMAP_COOL
        # cam = 0.5 * heatmap + 0.5 * np.float32(image)
        # cv2.imwrite('/mnt/huawei/jiaoxh/CGC/heatmap/divide/'+image_path.split('/')[-1], cam.astype(np.uint8))

        en_pg = energy_point_game(bbox, attribution_map_epg)
        pg = point_game(bbox, attribution_map_pg)

        pg_energy_value.append(en_pg)
        pg_value.append(pg)

    print("Point Game: {}".format(np.array(pg_value).mean()))
    print("Energy Point Game: {}".format(np.array(pg_energy_value).mean()))


if __name__ == "__main__":
    args = parse_args()
    main(args)