# CommandSans

Source code for training and evaluating the CommandSans model.

## Quick Start

### 1. Setup
```bash
# Install dependencies
pip install -r requirements.txt

# Create data directory
mkdir -p data/train-dataset data/test-dataset data/logs
```

### 2. Prepare Data
```bash
# Set your home directory path in the scripts
export HOME_DIR=/path/to/your/project

# Preprocess datasets (run notebooks in src/preprocess/)
# Then label your data:
./src/scripts/label.sh
```

### 3. Visualise Data
```bash
./src/scripts/visualise.sh
```

### 4. Train Model
```bash
./src/scripts/train.sh
```

### 5. Evaluate Model
```bash
./src/scripts/evaluate.sh
```

## Detailed Setup

### Data Preparation
1. Create `data/` folder in project root
2. Run preprocessing notebooks:
   - `src/preprocess/bfcl.ipynb` - BFCL dataset
   - `src/preprocess/orca.ipynb` - ORCA dataset
3. Label data using `src/scripts/label.sh`
4. Combine datasets into single training file
5. For test data: split training data or use [Agent Dojo traces](https://github.com/ethz-spylab/agentdojo/tree/main/runs)
6. You can visualise the labelled data using the `visualise.sh` script. 
7. Train and evaluate the model using the `train.sh` and `evaluate.sh` scripts.

**Note:** Update `HOME_DIR` variable in each script to point to your project directory.
