# Energy-Based Sample Adaptation at Test Time for Domain Generalization
Code for paper "Energy-Based Sample Adaptation at Test Time for Domain Generalization" submitted to NeurIPS 2022.

### Prerequisites
 - Python 3.7.9
 - Pytorch 1.7.1
 - GPU: a single NVIDIA Tesla V100

### Components
 - `../kfold224/`: Directory of images
 - `../files/`: Directory of the train/validation/test split txt files
 - `pacs_main.py`: script to run experiments on PACS
 - `pacs_model.py`: the model used in `pacs_main.py`
 - `ebm_dataset.py`: script to load data from PACS for the experiments
 - `./logs/`: folder to store the trained model
 - `augs.py`: data augmentation functions for the experiments 
 - `utils.py`: other needed functions for the experiments


## Setup
The code is for the PACS dataset. Download the datasets from the following link, extract the compressed file, and place the images in `../kfold224/` directory. 
The train/validation/test split txt files are already in the `../files/` directory.

[[Google Drive](https://drive.google.com/drive/folders/0B6x7gtvErXgfUU1WcGY5SzdwZVk)] provided by Li et al. in [[Deeper, Broader and Artier Domain Generalization](https://arxiv.org/pdf/1710.03077v1.pdf)]

## Training
For training the model run the following:
```
python pacs_main.py --test_domain art_painting --log_dir MODEL_NAME
```
Change the `art_painting` after `--test_domain` to `cartoon`, `photo` or `sketch` to change the target domain.
Use `--net res18/res50` to choose ResNet-18 or ResNet-50 as the backbone. The default value is `--net res18`.
Use `--lr` to set the learning rate of the model. The default value is `--lr 0.0001`.
Use `--step_lr` to set the step size of Langevin dynamics for updating the samples. The default value is `--step_lr 20`.
Use `--num_steps` to set the number of steps of Langevin dynamics for updating the samples. The default value is `--num_steps 50.0`.
The trained model and logs will be stored in `./logs/MODEL_NAME/`
