from typing import List, Tuple


def generate_taxonomy_sentences(taxonomy: str) -> List[Tuple[str, str]]:
    """
    Generate example sentences with diverse syntactic structures for a given taxonomy.
    Each highlighted token is guaranteed to be a single token.
    
    Args:
        taxonomy: The taxonomy name
        
    Returns:
        List of tuples (sentence, highlighted_token)
    """
    sentences = {
        "spatial_relationship": [
            ("The cat is on the table", "on"),
            ("She put the book under the chair", "under"),
            ("The plant grows beside the window", "beside"),
            ("The lamp hangs above the desk", "above"),
            ("The keys are inside the drawer", "inside"),
            ("The dog sits between two trees", "between"),
            ("The car parked behind the house", "behind"),
            ("The child stands near the fountain", "near"),
            ("He placed the shoes beneath the bed", "beneath"),
            ("The painting hangs over the fireplace", "over"),
            ("The toy fell off the shelf", "off"),
            ("The boat floats along the river", "along"),
            ("The fence runs around the yard", "around"),
            ("The path leads toward the mountain", "toward"),
            ("The restaurant is opposite the bank", "opposite"),
            ("The statue stands amid the garden", "amid"),
            ("She stood to the left of the store", "left"),
            ("The pen rolled down the table", "down"),
            ("The cat is to the right of the chair", "right"),
            ("The car drove through the tunnel", "through")
        ],
        "counting": [
            ("There are three apples in the basket", "three"),
            ("The teacher counted five children", "five"),
            ("They bought a dozen eggs", "dozen"),
            ("I need two cups of sugar", "two"),
            ("There is one glass on the table", "one"),
            ("The recipe requires four eggs", "four"),
            ("He made zero mistakes on the test", "zero"),
            ("She won seven medals in the competition", "seven"),
            ("I can see six birds on the wire", "six"),
            ("The box contains eight pencils", "eight"),
            ("She ate nine grapes for breakfast", "nine"),
            ("We need ten volunteers for the event", "ten"),
            ("The package has eleven items inside", "eleven"),
            ("There are twelve months in a year", "twelve"),
            ("I bought fifteen apples at the market", "fifteen"),
            ("The clock showed twenty minutes past nine", "twenty"),
            ("The team scored thirty points in the game", "thirty"),
            ("This bottle holds fifty milliliters of water", "fifty"),
            ("The book has forty chapters in total", "forty"),
            ("About sixty people attended the meeting", "sixty")
        ],
        "attribute": [
            ("The red car stopped at the light", "red"),
            ("She wore a beautiful dress", "beautiful"),
            ("The heavy box fell to the floor", "heavy"),
            ("A delicious meal was prepared", "delicious"),
            ("The smooth surface reflected light", "smooth"),
            ("A loud noise woke everyone up", "loud"),
            ("The ancient ruins fascinated tourists", "ancient"),
            ("The tiny insect landed on the leaf", "tiny"),
            ("A bright light illuminated the room", "bright"),
            ("The tall building cast a shadow", "tall"),
            ("Her soft voice calmed the child", "soft"),
            ("The sharp knife cut through the meat", "sharp"),
            ("The deep lake contains many fish", "deep"),
            ("A sour taste lingered in his mouth", "sour"),
            ("The narrow path led to the summit", "narrow"),
            ("The cold water refreshed the hikers", "cold"),
            ("An empty bottle rolled on the floor", "empty"),
            ("The young tree bent in the wind", "young"),
            ("His fierce expression frightened them", "fierce"),
            ("The sweet fragrance filled the room", "sweet")
        ],
        "entity": [
            ("The dog barked at the mailman", "dog"),
            ("A tree fell during the storm", "tree"),
            ("The computer crashed unexpectedly", "computer"),
            ("The child played in the park", "child"),
            ("The ocean waves crashed on rocks", "ocean"),
            ("The moon shone brightly at night", "moon"),
            ("A bird built a nest in the garden", "bird"),
            ("The mountain peak was snow covered", "mountain"),
            ("The phone rang in the night", "phone"),
            ("The cake was delicious and moist", "cake"),
            ("The car stopped at the light", "car"),
            ("A book sat on the desk", "book"),
            ("The river flooded the village", "river"),
            ("A cat chased the mouse", "cat"),
            ("The sun rose over the horizon", "sun"),
            ("Her house was painted blue", "house"),
            ("The plane landed safely", "plane"),
            ("The flower bloomed in spring", "flower"),
            ("The teacher explained the lesson", "teacher"),
            ("The key unlocked the door", "key")
        ],
        "action": [
            ("The athlete is running in the marathon", "running"),
            ("She is writing a novel", "writing"),
            ("The chef is cooking dinner", "cooking"),
            ("They are building a new house", "building"),
            ("The baby is sleeping peacefully", "sleeping"),
            ("The audience is clapping enthusiastically", "clapping"),
            ("The cat is chasing a mouse", "chasing"),
            ("He is driving to work", "driving"),
            ("The teacher is explaining the lesson", "explaining"),
            ("They are singing a beautiful song", "singing"),
            ("She is dancing gracefully", "dancing"),
            ("He is reading a book", "reading"),
            ("The dog is barking loudly", "barking"),
            ("The students are studying for exams", "studying"),
            ("They are walking along the beach", "walking"),
            ("She is painting a landscape", "painting"),
            ("The birds are flying south", "flying"),
            ("He is swimming in the lake", "swimming"),
            ("She is laughing at the joke", "laughing"),
            ("They are eating dinner together", "eating")
        ],
        "temporal": [
            ("I will call you after the meeting", "after"),
            ("Before sunrise they began hiking", "Before"),
            ("During the concert it started raining", "During"),
            ("She arrived while we were eating", "while"),
            ("Until tomorrow we won't know", "Until"),
            ("Since last year things have changed", "Since"),
            ("We waited until the storm passed", "until"),
            ("He was nervous before his speech", "before"),
            ("Following the ceremony was a reception", "Following"),
            ("She completed her work subsequently", "subsequently"),
            ("She always arrives early", "always"),
            ("They never visit on Sundays", "never"),
            ("He sometimes forgets his keys", "sometimes"),
            ("The shop opens daily at nine", "daily"),
            ("They meet weekly to discuss progress", "weekly"),
            ("The train arrives hourly", "hourly"),
            ("Soon the winter will arrive", "Soon"),
            ("Later we can discuss that issue", "Later"),
            ("Currently we face many challenges", "Currently"),
            ("Eventually everyone left the party", "Eventually")
        ],
        "comparison": [
            ("This book is better than that one", "better"),
            ("She runs faster than her brother", "faster"),
            ("The blue car is more expensive", "more"),
            ("This is the largest building in town", "largest"),
            ("He scored higher on the test", "higher"),
            ("The weather is worse today", "worse"),
            ("These shoes are cheaper than those", "cheaper"),
            ("This is the most beautiful painting", "most"),
            ("The new phone is smaller but powerful", "smaller"),
            ("Today's assignment was easier", "easier"),
            ("She is taller than her sister", "taller"),
            ("This coffee is stronger than usual", "stronger"),
            ("His car is newer than mine", "newer"),
            ("Her voice is louder than his", "louder"),
            ("This method is simpler to understand", "simpler"),
            ("That explanation was clearer", "clearer"),
            ("The blue team performed best", "best"),
            ("This soup tastes sweeter", "sweeter"),
            ("The older building looks nicer", "nicer"),
            ("Their house is bigger than ours", "bigger")
        ],
        "negation": [
            ("He did not attend the meeting", "not"),
            ("There is no water in the glass", "no"),
            ("She never eats meat", "never"),
            ("They could not find their keys", "not"),
            ("It is impossible to finish on time", "impossible"),
            ("The store is nowhere near here", "nowhere"),
            ("Nothing happened after we left", "Nothing"),
            ("I barely slept last night", "barely"),
            ("They hardly recognized their friend", "hardly"),
            ("The package has not arrived yet", "not"),
            ("Nobody came to the party", "Nobody"),
            ("He refuses to cooperate with us", "refuses"),
            ("I disagree with your opinion", "disagree"),
            ("She denied breaking the window", "denied"),
            ("They rejected our proposal", "rejected"),
            ("The claim lacks supporting evidence", "lacks"),
            ("She failed the examination", "failed"),
            ("The project was unsuccessful", "unsuccessful"),
            ("He forbids smoking in his house", "forbids"),
            ("I cannot remember her name", "cannot")
        ]
    }
    
    return sentences.get(taxonomy, [])