import torch
import numpy as np
import random

# fix all seeds for reproducibility
def fix_all_seed(seed):
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.benchmark = False
    torch.backends.cudnn.deterministic = True

    np.random.seed(seed)

    random.seed(seed)

def parse_key_value_pairs(pairs):
    if pairs is None:
        return {}
    result = {}
    for pair in pairs:
        key, value = pair.split('=')
        result[key] = value
    return result

def get_device():
    return torch.device("cuda" if torch.cuda.is_available() else "cpu")

def convert_value(value):
    try:
        return float(value)
    except ValueError:
        return value

def convert_dict_values(dictionary):
    if not isinstance(dictionary, dict):
        return dictionary
    return {key: convert_value(value) for key, value in dictionary.items()}