import os
import pandas as pd
import glob

# function to get first epoch when averaged window key value reaches target value
def get_first_epoch(df, target_value, window_size, key):
    window_average = df[key].rolling(window=window_size).mean()
    first_epochs_indexes = window_average[window_average >= target_value].index
    if len(first_epochs_indexes) == 0:
        return None
    first_epoch_index = first_epochs_indexes[0]
    first_epoch = df.iloc[first_epoch_index]['Epoch']
    return first_epoch

def get_exp_logs(folder, param_values, format='csv'):
    file_name = os.path.join(folder, '-'.join(param_values) + '.' + format)
    df = pd.read_csv(file_name)
    return df

def find_and_read_files(directory, pattern):
    return_dfs = []
    for file in glob.glob(os.path.join(directory, pattern)):
        return_dfs.append(pd.read_csv(file))
    return return_dfs

