#!/bin/bash
# WORKER_LR_RANGE=(0.00001 0.0001 0.001 0.01 0.1)
WORKER_LR_RANGE=(0.0005 0.001 0.0025 0.005)

for lr in ${WORKER_LR_RANGE[@]}; do
    python3 script.py \
        --seed 42 \
        --folder logs/ \
        --epochs 1000 \
        --wandb \
        --gamma 1.0 \
        --cohort_optimizer Prox \
        --worker_optimizer Adam \
        --worker_optimizer_steps 3 \
        --worker_optimizer_hparams lr=$lr \
        --server_optimizer Adam \
        --server_optimizer_steps 3 \
        --server_optimizer_hparams lr=$lr \
        --sampler Nice \
        --minibatch_size 10 \
        --device cuda \
        --process_count 1 \
        --dataset FEMNIST_original \
        --workers_count 100 &

    # sleep 30
done

wait