#!/bin/bash
# WORKER_LR_RANGE=(0.00001 0.0001 0.001 0.01 0.1)
WORKER_LR_RANGE=(0.05 0.1 0.25 0.5)

for lr in ${WORKER_LR_RANGE[@]}; do
    python3 script.py \
        --seed 42 \
        --folder logs/ \
        --epochs 1000 \
        --wandb \
        --gamma 1.0 \
        --cohort_optimizer Prox \
        --worker_optimizer SGD \
        --worker_optimizer_steps 3 \
        --worker_optimizer_hparams lr=$lr \
        --server_optimizer SGD \
        --server_optimizer_steps 3 \
        --server_optimizer_hparams lr=1.0 \
        --sampler Nice \
        --minibatch_size 10 \
        --device cuda \
        --process_count 1 \
        --dataset FEMNIST_original \
        --workers_count 100 &

    # sleep 30
done

wait