# HyPER Code

This is an initial codebase to train the HyPER model. We outline how to generate data and train models below.

## Disclaimer

This code has not been tested outside of our server environment so there may be unforseen issues with setup, package installation and running the code.

## Install Required Packages

1. If you use conda: `conda create --name <env> --file requirements.txt`
2. If you use pip: `pip install -r requirements.txt`

## Generate Navier-Stokes Dataset

`python data/generate_navier_stokes.py`

## Train UNet Surrogate Model

`cd src`
`python train_one_step_ns.py`

## Train FNO Surrogate Model

`python train_one_step_ns_fno.py`

## Train RL Model

`python train_rl_multistep_reinforce_ns_simple_baseline.py`

## Evaluate Models

1. `python test_rl_multistep_reinforce_random_baseline_ns.py`
2. Evaluation plots, videos, and metrics hdf5 file should be output to `../rl-test-results-ns/test-rl-multistep-4-reinforce-ns-64-lam-0.3-lr-1e-5-epoch-best-val-bs-1-ts-20-simple-baseline-final-advantage-penalty-1x-sim-penalty-1x-resnet34-best-testval-set-1`

