# Environment Setup Guide

This document provides detailed instructions for setting up the environment for FedPOB and FedPOB-Pref.

## Quick Setup

### Option 1: Automated Setup (Recommended)

**Linux/macOS:**
```bash
chmod +x setup_environment.sh
./setup_environment.sh
```

**Windows:**
```cmd
setup_environment.bat
```

### Option 2: Manual Setup

#### Using Conda (Recommended)
```bash
conda env create -f environment.yml
conda activate fedpob
```

#### Using pip
```bash
python -m venv venv
source venv/bin/activate  # Linux/macOS
# or
venv\Scripts\activate.bat  # Windows

pip install -r requirements.txt
```

## System Requirements

- **Python**: 3.8+ (3.9 recommended)
- **Operating System**: Linux, macOS, or Windows
- **Memory**: 8GB RAM minimum, 16GB recommended
- **Storage**: 5GB free space
- **GPU**: CUDA-compatible GPU (optional but recommended)

## Core Dependencies

### Required Packages
- `torch>=1.9.0` - PyTorch for deep learning
- `transformers>=4.20.0` - Hugging Face transformers
- `sentence-transformers>=2.2.0` - Sentence embeddings
- `numpy>=1.21.0` - Numerical computing
- `pandas>=1.3.0` - Data manipulation
- `tqdm>=4.62.0` - Progress bars

### API Dependencies
- `openai>=0.27.0` - OpenAI API client
- `requests>=2.25.0` - HTTP requests

### Utility Dependencies
- `nest-asyncio>=1.5.0` - Async support
- `pyyaml>=6.0` - Configuration files
- `matplotlib>=3.5.0` - Plotting

## API Configuration

Set your API keys as environment variables:

```bash
export OPENAI_API_KEY="your_openai_api_key"
export OPENROUTER_API_KEY="your_openrouter_api_key"
```

**Windows:**
```cmd
set OPENAI_API_KEY=your_openai_api_key
set OPENROUTER_API_KEY=your_openrouter_api_key
```

## Docker Setup

Build and run with Docker:

```bash
docker build -t fedpob .
docker run -it --rm \
  -e OPENAI_API_KEY="your_key" \
  -e OPENROUTER_API_KEY="your_key" \
  -v $(pwd)/results:/app/results \
  fedpob python main/Induction/experiments/FedPOB.py --task boolean_expressions
```

## GPU Support

For CUDA support, ensure you have:
- NVIDIA GPU with CUDA capability
- CUDA toolkit installed
- PyTorch with CUDA support

Install PyTorch with CUDA:
```bash
pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
```

## Verification

Test your installation:

```bash
cd main/Induction/experiments
python -c "import torch; print(f'PyTorch: {torch.__version__}'); print(f'CUDA available: {torch.cuda.is_available()}')"
python FedPOB.py --help
```

## Troubleshooting

### Common Issues

1. **Import Error**: Ensure all dependencies are installed
2. **CUDA Error**: Check GPU drivers and CUDA installation
3. **API Error**: Verify API keys are set correctly
4. **Memory Error**: Reduce batch size or use CPU

### Getting Help

If you encounter issues:
1. Check the error message carefully
2. Verify all dependencies are installed
3. Ensure API keys are configured
4. Check system requirements

## Development Setup

For development, install additional tools:

```bash
pip install pytest black flake8 jupyter
```

Run tests:
```bash
pytest tests/
```

Format code:
```bash
black main/Induction
```
