import sys

def main():
    # Verificar se temos o número correto de argumentos
    if len(sys.argv) != 4:
        print("Uso: python script.py <caminho_arquivo> <k_inicial> <k_final>")
        sys.exit(1)
    
    file_path = sys.argv[1]
    k_start = int(sys.argv[2])
    k_end = int(sys.argv[3])
    
    try:
        # Ler o arquivo
        with open(file_path, 'r', encoding='utf-8') as file:
            content = file.read()
        
        # Para cada k no intervalo especificado
        for k in range(k_start, k_end + 1):
            # Definir as strings a serem procuradas
            string_a = f'][Soln. Length: {k}]'
            string_b = f'[Lenght: {k}]'
            string_c = f'[Lenght: {k}]['
            string_d = string_a
            
            # Contar ocorrências
            a = content.count(string_a)
            b = content.count(string_b)
            c = content.count(string_c)
            d = content.count(string_d)
            
            # Calcular a / (b - c + d)
            denominator = b - c + d
            
            if denominator != 0:
                result = a / denominator
                print(f"k = {k}: a = {a}, b = {b}, c = {c}, d = {d}, resultado = {result:.2f}")
            else:
                print(f"k = {k}: a = {a}, b = {b}, c = {c}, d = {d}, resultado = indefinido (divisão por zero)")
    
    except FileNotFoundError:
        print(f"Erro: Arquivo '{file_path}' não encontrado.")
        sys.exit(1)
    except ValueError as e:
        print(f"Erro: Os argumentos k_inicial e k_final devem ser números inteiros.")
        sys.exit(1)
    except Exception as e:
        print(f"Erro inesperado: {e}")
        sys.exit(1)

if __name__ == "__main__":
    main()
