####### TODO: check the column order

problems = {
    "feynman_I_6_2": {
        "description": """
            f = exp(-(theta/sigma)**2/2) / (sqrt(2*pi)*sigma)
            sigma in [1.0,3.0]
            theta in [1.0,3.0]
        """,
        "prefix": "* CONST / exp * CONST square / y x x",
    },
    "feynman_I_6_2a": {
        "description": """
            f = exp(-theta**2/2)/sqrt(2*pi)
            theta in [1.0,3.0]
        """,
        "prefix": "* CONST exp * CONST square x",
    },
    "feynman_I_6_2b": {
        "description": """
            f = exp(-((theta-theta1)/sigma)**2/2) / (sqrt(2*pi)*sigma)
            sigma in [1.0,3.0]
            theta in [1.0,3.0]
            theta1 in [1.0,3.0]
        """,
        "prefix": "* CONST / exp * CONST square / - y z x x",
    },
    "feynman_I_8_14": {
        "description": """
            d = sqrt((x2-x1)**2+(y2-y1)**2)
            x1 in [1.0,5.0]
            x2 in [1.0,5.0]
            y1 in [1.0,5.0]
            y2 in [1.0,5.0]
        """,
        "prefix": "sqrt + square - y x square - w z",
    },
    "feynman_I_9_18": {
        "description": """
            F = G*m1*m2/((x2-x1)**2+(y2-y1)**2+(z2-z1)**2)
            m1 in [1.0,2.0]
            m2 in [1.0,2.0]
            G in [1.0,2.0]
            x1 in [3.0,4.0]
            x2 in [1.0,2.0]
            y1 in [3.0,4.0]
            y2 in [1.0,2.0]
            z1 in [3.0,4.0]
            z2 in [1.0,2.0]
        """,
        "prefix": "",
    },
    "feynman_I_10_7": {
        "description": """
            m = m_0/sqrt(1-v**2/c**2)
            m_0 in [1.0,5.0]
            v in [1.0,2.0]
            c in [3.0,10.0]
        """,
        "prefix": "/ x sqrt - CONST square / y z",
    },
    "feynman_I_11_19": {
        "description": """
            A = x1*y1+x2*y2+x3*y3
            x1 in [1.0,5.0]
            x2 in [1.0,5.0]
            x3 in [1.0,5.0]
            y1 in [1.0,5.0]
            y2 in [1.0,5.0]
            y3 in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_I_12_1": {
        "description": """
            F = mu*Nn
            mu in [1.0,5.0]
            Nn in [1.0,5.0]
        """,
        "prefix": "* x y",
    },
    "feynman_I_12_2": {
        "description": """
            F = q1*q2*r/(4*pi*epsilon*r**3)
            q1 in [1.0,5.0]
            q2 in [1.0,5.0]
            epsilon in [1.0,5.0]
            r in [1.0,5.0]
        """,
        "prefix": "* CONST / * x y * z square w",
    },
    "feynman_I_12_4": {
        "description": """
            Ef = q1*r/(4*pi*epsilon*r**3)
            q1 in [1.0,5.0]
            epsilon in [1.0,5.0]
            r in [1.0,5.0]
        """,
        "prefix": "* CONST / x * y square z",
    },
    "feynman_I_12_5": {
        "description": """
            F = q2*Ef
            q2 in [1.0,5.0]
            Ef in [1.0,5.0]
        """,
        "prefix": "* x y",
    },
    "feynman_I_12_11": {
        "description": """
            F = q*(Ef+B*v*sin(theta))
            q in [1.0,5.0]
            Ef in [1.0,5.0]
            B in [1.0,5.0]
            v in [1.0,5.0]
            theta in [1.0,5.0]
        """,
        "prefix": "* x + y * z * w sin a",
    },
    "feynman_I_13_4": {
        "description": """
            K = 1/2*m*(v**2+u**2+w**2)
            m in [1.0,5.0]
            v in [1.0,5.0]
            u in [1.0,5.0]
            w in [1.0,5.0]
        """,
        "prefix": "* CONST * x + square y + square z square w",
    },
    "feynman_I_13_12": {
        "description": """
            U = G*m1*m2*(1/r2-1/r1)
            m1 in [1.0,5.0]
            m2 in [1.0,5.0]
            r1 in [1.0,5.0]
            r2 in [1.0,5.0]
            G in [1.0,5.0]
        """,
        "prefix": "* a * x * y - / CONST w / CONST z",
    },
    "feynman_I_14_3": {
        "description": """
            U = m*g*z
            m in [1.0,5.0]
            g in [1.0,5.0]
            z in [1.0,5.0]
        """,
        "prefix": "* x * y z",
    },
    "feynman_I_14_4": {
        "description": """
            U = 1/2*k_spring*x**2
            k_spring in [1.0,5.0]
            x in [1.0,5.0]
        """,
        "prefix": "* CONST * x square y",
    },
    "feynman_I_15_3t": {
        "description": """
            t1 = (t-u*x/c**2)/sqrt(1-u**2/c**2)
            x in [1.0,5.0]
            c in [3.0,10.0]
            u in [1.0,2.0]
            t in [1.0,5.0]
        """,
        "prefix": "/ - w / * z x square y sqrt - CONST square / z y",
    },
    "feynman_I_15_3x": {
        "description": """
            x1 = (x-u*t)/sqrt(1-u**2/c**2)
            x in [5.0,10.0]
            u in [1.0,2.0]
            c in [3.0,20.0]
            t in [1.0,2.0]
        """,
        "prefix": "/ - x * y w sqrt - CONST square / y z",
    },
    "feynman_I_15_10": {
        "description": """
            p = m_0*v/sqrt(1-v**2/c**2)
            m_0 in [1.0,5.0]
            v in [1.0,2.0]
            c in [3.0,10.0]
        """,
        "prefix": "/ * x y sqrt - CONST square / y z",
    },
    "feynman_I_16_6": {
        "description": """
            v1 = (u+v)/(1+u*v/c**2)
            c in [1.0,5.0]
            v in [1.0,5.0]
            u in [1.0,5.0]
        """,
        "prefix": "/ + y z + CONST / * y z square x",
    },
    "feynman_I_18_4": {
        "description": """
            r = (m1*r1+m2*r2)/(m1+m2)
            m1 in [1.0,5.0]
            m2 in [1.0,5.0]
            r1 in [1.0,5.0]
            r2 in [1.0,5.0]
        """,
        "prefix": "/ + * x z * y w + x y",
    },
    "feynman_I_18_12": {
        "description": """
            tau = r*F*sin(theta)
            r in [1.0,5.0]
            F in [1.0,5.0]
            theta in [0.0,5.0]
        """,
        "prefix": "* x * y sin z",
    },
    "feynman_I_18_14": {
        "description": """
            L = m*r*v*sin(theta)
            m in [1.0,5.0]
            r in [1.0,5.0]
            v in [1.0,5.0]
            theta in [1.0,5.0]
        """,
        "prefix": "* x * y * z sin w",
    },
    "feynman_I_24_6": {
        "description": """
            E_n = 1/2*m*(omega**2+omega_0**2)*1/2*x**2
            m in [1.0,3.0]
            omega in [1.0,3.0]
            omega_0 in [1.0,3.0]
            x in [1.0,3.0]
        """,
        "prefix": "* CONST * x * + square y square z square w",
    },
    "feynman_I_25_13": {
        "description": """
            Volt = q/C
            q in [1.0,5.0]
            C in [1.0,5.0]
        """,
        "prefix": "/ x y",
    },
    "feynman_I_26_2": {
        "description": """
            theta1 = arcsin(n*sin(theta2))
            n in [0.0,1.0]
            theta2 in [1.0,5.0]
        """,
        "prefix": "arcsin * x sin y",
    },
    "feynman_I_27_6": {
        "description": """
            foc = 1/(1/d1+n/d2)
            d1 in [1.0,5.0]
            d2 in [1.0,5.0]
            n in [1.0,5.0]
        """,
        "prefix": "/ CONST + / CONST x / z y",
    },
    "feynman_I_29_4": {
        "description": """
            k = omega/c
            omega in [1.0,10.0]
            c in [1.0,10.0]
        """,
        "prefix": "/ x y",
    },
    "feynman_I_29_16": {
        "description": """
            x = sqrt(x1**2+x2**2-2*x1*x2*cos(theta1-theta2))
            x1 in [1.0,5.0]
            x2 in [1.0,5.0]
            theta1 in [1.0,5.0]
            theta2 in [1.0,5.0]
        """,
        "prefix": "sqrt + square x + square y - * CONST * x * y cos - z w",
    },
    "feynman_I_30_3": {
        "description": """
            Int = Int_0*sin(n*theta/2)**2/sin(theta/2)**2
            Int_0 in [1.0,5.0]
            theta in [1.0,5.0]
            n in [1.0,5.0]
        """,
        "prefix": "* x square / sin * CONST * z y sin * CONST y",
    },
    "feynman_I_30_5": {
        "description": """
            theta = arcsin(lambd/(n*d))
            lambd in [1.0,2.0]
            d in [2.0,5.0]
            n in [1.0,5.0]
        """,
        "prefix": "arcsin / x * y z",
    },
    "feynman_I_32_5": {
        "description": """
            Pwr = q**2*a**2/(6*pi*epsilon*c**3)
            q in [1.0,5.0]
            a in [1.0,5.0]
            epsilon in [1.0,5.0]
            c in [1.0,5.0]
        """,
        "prefix": "* CONST / square * x y * z * square w w",
    },
    "feynman_I_32_17": {
        "description": """
            Pwr = (1/2*epsilon*c*Ef**2)*(8*pi*r**2/3)*(omega**4/(omega**2-omega_0**2)**2)
            epsilon in [1.0,2.0]
            c in [1.0,2.0]
            Ef in [1.0,2.0]
            r in [1.0,2.0]
            omega in [1.0,2.0]
            omega_0 in [3.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_I_34_1": {
        "description": """
            omega = omega_0/(1-v/c)
            c in [3.0,10.0]
            v in [1.0,2.0]
            omega_0 in [1.0,5.0]
        """,
        "prefix": "/ z - CONST / y x",
    },
    "feynman_I_34_8": {
        "description": """
            omega = q*v*B/p
            q in [1.0,5.0]
            v in [1.0,5.0]
            B in [1.0,5.0]
            p in [1.0,5.0]
        """,
        "prefix": "* x * y / z w",
    },
    "feynman_I_34_14": {
        "description": """
            omega = (1+v/c)/sqrt(1-v**2/c**2)*omega_0
            c in [3.0,10.0]
            v in [1.0,2.0]
            omega_0 in [1.0,5.0]
        """,
        "prefix": "* / + CONST / y x sqrt - CONST / square y square x z",
    },
    "feynman_I_34_27": {
        "description": """
            E_n = (h/(2*pi))*omega
            omega in [1.0,5.0]
            h in [1.0,5.0]
        """,
        "prefix": "* CONST * y x",
    },
    "feynman_I_37_4": {
        "description": """
            Int = I1+I2+2*sqrt(I1*I2)*cos(delta)
            I1 in [1.0,5.0]
            I2 in [1.0,5.0]
            delta in [1.0,5.0]
        """,
        "prefix": "+ x + y * CONST * sqrt * x y cos z",
    },
    "feynman_I_38_12": {
        "description": """
            r = 4*pi*epsilon*(h/(2*pi))**2/(m*q**2)
            m in [1.0,5.0]
            q in [1.0,5.0]
            h in [1.0,5.0]
            epsilon in [1.0,5.0]
        """,
        "prefix": "* CONST * w / square / z y x",
    },
    "feynman_I_39_1": {
        "description": """
            E_n = 3/2*pr*V
            pr in [1.0,5.0]
            V in [1.0,5.0]
        """,
        "prefix": "* CONST * x y",
    },
    "feynman_I_39_11": {
        "description": """
            E_n = 1/(gamma-1)*pr*V
            gamma in [2.0,5.0]
            pr in [1.0,5.0]
            V in [1.0,5.0]
        """,
        "prefix": "/ CONST * - x CONST * y z",
    },
    "feynman_I_39_22": {
        "description": """
            pr = n*kb*T/V
            n in [1.0,5.0]
            T in [1.0,5.0]
            V in [1.0,5.0]
            kb in [1.0,5.0]
        """,
        "prefix": "* x * w / y z",
    },
    "feynman_I_40_1": {
        "description": """
            n = n_0*exp(-m*g*x/(kb*T))
            n_0 in [1.0,5.0]
            m in [1.0,5.0]
            x in [1.0,5.0]
            T in [1.0,5.0]
            g in [1.0,5.0]
            kb in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_I_41_16": {
        "description": """
            L_rad = h/(2*pi)*omega**3/(pi**2*c**2*(exp((h/(2*pi))*omega/(kb*T))-1))
            omega in [1.0,5.0]
            T in [1.0,5.0]
            h in [1.0,5.0]
            kb in [1.0,5.0]
            c in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_I_43_16": {
        "description": """
            v = mu_drift*q*Volt/d
            mu_drift in [1.0,5.0]
            q in [1.0,5.0]
            Volt in [1.0,5.0]
            d in [1.0,5.0]
        """,
        "prefix": "* x * y / z w",
    },
    "feynman_I_43_31": {
        "description": """
            D = mob*kb*T
            mob in [1.0,5.0]
            T in [1.0,5.0]
            kb in [1.0,5.0]
        """,
        "prefix": "* x * z y",
    },
    "feynman_I_43_43": {
        "description": """
            kappa = 1/(gamma-1)*kb*v/A
            gamma in [2.0,5.0]
            kb in [1.0,5.0]
            A in [1.0,5.0]
            v in [1.0,5.0]
        """,
        "prefix": "/ * y w * z - x CONST",
    },
    "feynman_I_44_4": {
        "description": """
            E_n = n*kb*T*ln(V2/V1)
            n in [1.0,5.0]
            kb in [1.0,5.0]
            T in [1.0,5.0]
            V1 in [1.0,5.0]
            V2 in [1.0,5.0]
        """,
        "prefix": "* x * y * z ln / a w",
    },
    "feynman_I_47_23": {
        "description": """
            c = sqrt(gamma*pr/rho)
            gamma in [1.0,5.0]
            pr in [1.0,5.0]
            rho in [1.0,5.0]
        """,
        "prefix": "sqrt / * x y z",
    },
    "feynman_I_48_2": {
        "description": """
            E_n = m*c**2/sqrt(1-v**2/c**2)
            m in [1.0,5.0]
            v in [1.0,2.0]
            c in [3.0,10.0]
        """,
        "prefix": "* x / square z sqrt - CONST square / y z",
    },
    "feynman_I_50_26": {
        "description": """
            x = x1*(cos(omega*t)+alpha*cos(omega*t)**2)
            x1 in [1.0,3.0]
            omega in [1.0,3.0]
            t in [1.0,3.0]
            alpha in [1.0,3.0]
        """,
        "prefix": "* x + cos * y z * w square cos * y z",
    },
    "feynman_II_2_42": {
        "description": """
            Pwr = kappa*(T2-T1)*A/d
            kappa in [1.0,5.0]
            T1 in [1.0,5.0]
            T2 in [1.0,5.0]
            A in [1.0,5.0]
            d in [1.0,5.0]
        """,
        "prefix": "/ * x * w - z y a",
    },
    "feynman_II_3_24": {
        "description": """
            flux = Pwr/(4*pi*r**2)
            Pwr in [1.0,5.0]
            r in [1.0,5.0]
        """,
        "prefix": "* CONST / x square y",
    },
    "feynman_II_4_23": {
        "description": """
            Volt = q/(4*pi*epsilon*r)
            q in [1.0,5.0]
            epsilon in [1.0,5.0]
            r in [1.0,5.0]
        """,
        "prefix": "* CONST / x * y z",
    },
    "feynman_II_6_11": {
        "description": """
            Volt = 1/(4*pi*epsilon)*p_d*cos(theta)/r**2
            epsilon in [1.0,3.0]
            p_d in [1.0,3.0]
            theta in [1.0,3.0]
            r in [1.0,3.0]
        """,
        "prefix": "* CONST / * y cos z * x square w",
    },
    "feynman_II_6_15a": {
        "description": """
            Ef = p_d/(4*pi*epsilon)*3*z/r**5*sqrt(x**2+y**2)
            epsilon in [1.0,3.0]
            p_d in [1.0,3.0]
            r in [1.0,3.0]
            x in [1.0,3.0]
            y in [1.0,3.0]
            z in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_II_6_15b": {
        "description": """
            Ef = p_d/(4*pi*epsilon)*3*cos(theta)*sin(theta)/r**3
            epsilon in [1.0,3.0]
            p_d in [1.0,3.0]
            theta in [1.0,3.0]
            r in [1.0,3.0]
        """,
        "prefix": "* CONST / * y * cos z sin z * x * square w w",
    },
    "feynman_II_8_7": {
        "description": """
            E_n = 3/5*q**2/(4*pi*epsilon*d)
            q in [1.0,5.0]
            epsilon in [1.0,5.0]
            d in [1.0,5.0]
        """,
        "prefix": "* CONST / square x * y z",
    },
    "feynman_II_8_31": {
        "description": """
            E_den = epsilon*Ef**2/2
            epsilon in [1.0,5.0]
            Ef in [1.0,5.0]
        """,
        "prefix": "* CONST * x square y",
    },
    "feynman_II_10_9": {
        "description": """
            Ef = sigma_den/epsilon*1/(1+chi)
            sigma_den in [1.0,5.0]
            epsilon in [1.0,5.0]
            chi in [1.0,5.0]
        """,
        "prefix": "* / x y / CONST + CONST z",
    },
    "feynman_II_11_3": {
        "description": """
            x = q*Ef/(m*(omega_0**2-omega**2))
            q in [1.0,3.0]
            Ef in [1.0,3.0]
            m in [1.0,3.0]
            omega_0 in [3.0,5.0]
            omega in [1.0,2.0]
        """,
        "prefix": "/ * x y * z - square w square a",
    },
    "feynman_II_11_20": {
        "description": """
            Pol = n_rho*p_d**2*Ef/(3*kb*T)
            n_rho in [1.0,5.0]
            p_d in [1.0,5.0]
            Ef in [1.0,5.0]
            kb in [1.0,5.0]
            T in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_II_11_27": {
        "description": """
            Pol = n*alpha/(1-(n*alpha/3))*epsilon*Ef
        n in [0.0,1.0]
        alpha in [0.0,1.0]
        epsilon in [1.0,2.0]
        Ef in [1.0,2.0]
        """,
        "prefix": "* CONST / * x * y * z w - CONST * x y",
    },
    "feynman_II_11_28": {
        "description": """
            theta = 1+n*alpha/(1-(n*alpha/3))
            n in [0.0,1.0]
            alpha in [0.0,1.0]
        """,
        "prefix": "+ CONST * x / y - CONST * CONST * x y",
    },
    "feynman_II_13_17": {
        "description": """
            B = 1/(4*pi*epsilon*c**2)*2*I/r
            epsilon in [1.0,5.0]
            c in [1.0,5.0]
            I in [1.0,5.0]
            r in [1.0,5.0]
        """,
        "prefix": "* CONST / z * x * square y w",
    },
    "feynman_II_13_23": {
        "description": """
            rho_c = rho_c_0/sqrt(1-v**2/c**2)
            rho_c_0 in [1.0,5.0]
            v in [1.0,2.0]
            c in [3.0,10.0]
        """,
        "prefix": "/ x sqrt - CONST square / y z",
    },
    "feynman_II_13_34": {
        "description": """
            j = rho_c_0*v/sqrt(1-v**2/c**2)
            rho_c_0 in [1.0,5.0]
            v in [1.0,2.0]
            c in [3.0,10.0]
        """,
        "prefix": "* x / y sqrt - CONST square / y z",
    },
    "feynman_II_15_4": {
        "description": """
            E_n = -mom*B*cos(theta)
            mom in [1.0,5.0]
            B in [1.0,5.0]
            theta in [1.0,5.0]
        """,
        "prefix": "* CONST * x * y cos z",
    },
    "feynman_II_15_5": {
        "description": """
            E_n = -p_d*Ef*cos(theta)
            p_d in [1.0,5.0]
            Ef in [1.0,5.0]
            theta in [1.0,5.0]
        """,
        "prefix": "* CONST * x * y cos z",
    },
    "feynman_II_21_32": {
        "description": """
            Volt = q/(4*pi*epsilon*r*(1-v/c))
            q in [1.0,5.0]
            epsilon in [1.0,5.0]
            r in [1.0,5.0]
            v in [1.0,2.0]
            c in [3.0,10.0]
        """,
        "prefix": "* CONST / * x a * y * z - a w",
    },
    "feynman_II_24_17": {
        "description": """
            k = sqrt(omega**2/c**2-pi**2/d**2)
            omega in [4.0,6.0]
            c in [1.0,2.0]
            d in [2.0,4.0]
        """,
        "prefix": "sqrt - square / x y / CONST square z",
    },
    "feynman_II_27_16": {
        "description": """
            flux = epsilon*c*Ef**2
            epsilon in [1.0,5.0]
            c in [1.0,5.0]
            Ef in [1.0,5.0]
        """,
        "prefix": "* x * y square z",
    },
    "feynman_II_27_18": {
        "description": """
            E_den = epsilon*Ef**2
            epsilon in [1.0,5.0]
            Ef in [1.0,5.0]
        """,
        "prefix": "* x square y",
    },
    "feynman_II_34_2": {
        "description": """
            mom = q*v*r/2
            q in [1.0,5.0]
            v in [1.0,5.0]
            r in [1.0,5.0]
        """,
        "prefix": "* CONST * x * y z",
    },
    "feynman_II_34_2a": {
        "description": """
            I = q*v/(2*pi*r)
            q in [1.0,5.0]
            v in [1.0,5.0]
            r in [1.0,5.0]
        """,
        "prefix": "/ * x y * CONST z",
    },
    "feynman_II_34_11": {
        "description": """
            omega = g_*q*B/(2*m)
            g_ in [1.0,5.0]
            q in [1.0,5.0]
            B in [1.0,5.0]
            m in [1.0,5.0]
        """,
        "prefix": "* CONST * x * y / z w",
    },
    "feynman_II_34_29a": {
        "description": """
            mom = q*h/(4*pi*m)
            q in [1.0,5.0]
            h in [1.0,5.0]
            m in [1.0,5.0]
        """,
        "prefix": "/ * x y * CONST z",
    },
    "feynman_II_34_29b": {
        "description": """
            E_n = g_*mom*B*Jz/(h/(2*pi))
            g_ in [1.0,5.0]
            h in [1.0,5.0]
            Jz in [1.0,5.0]
            mom in [1.0,5.0]
            B in [1.0,5.0]
        """,
        "prefix": "* CONST * x * w * a / z y",
    },
    "feynman_II_35_18": {
        "description": """
            n = n_0/(exp(mom*B/(kb*T))+exp(-mom*B/(kb*T)))
            n_0 in [1.0,3.0]
            kb in [1.0,3.0]
            T in [1.0,3.0]
            mom in [1.0,3.0]
            B in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_II_35_21": {
        "description": """
            M = n_rho*mom*tanh(mom*B/(kb*T))
            n_rho in [1.0,5.0]
            mom in [1.0,5.0]
            B in [1.0,5.0]
            kb in [1.0,5.0]
            T in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_II_36_38": {
        "description": """
            f = mom*H/(kb*T)+(mom*alpha)/(epsilon*c**2*kb*T)*M
            mom in [1.0,3.0]
            H in [1.0,3.0]
            kb in [1.0,3.0]
            T in [1.0,3.0]
            alpha in [1.0,3.0]
            epsilon in [1.0,3.0]
            c in [1.0,3.0]
            M in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_II_37_1": {
        "description": """
            E_n = mom*(1+chi)*B
            mom in [1.0,5.0]
            B in [1.0,5.0]
            chi in [1.0,5.0]
        """,
        "prefix": "* x * + CONST z y",
    },
    "feynman_II_38_3": {
        "description": """
            F = Y*A*x/d
            Y in [1.0,5.0]
            A in [1.0,5.0]
            d in [1.0,5.0]
            x in [1.0,5.0]
        """,
        "prefix": "* x * y / w z",
    },
    "feynman_II_38_14": {
        "description": """
            mu_S = Y/(2*(1+sigma))
            Y in [1.0,5.0]
            sigma in [1.0,5.0]
        """,
        "prefix": "/ x * CONST + CONST y",
    },
    "feynman_III_4_32": {
        "description": """
            n = 1/( exp( (h/(2*pi)) * omega/(kb*T)) - 1 )
            h in [1.0,5.0]
            omega in [1.0,5.0]
            kb in [1.0,5.0]
            T in [1.0,5.0]
        """,
        "prefix": "/ CONST - exp * CONST * x / y * z w CONST",
    },
    "feynman_III_4_33": {
        "description": """
            E_n = (h/(2*pi))*omega/(exp((h/(2*pi))*omega/(kb*T))-1)
            h in [1.0,5.0]
            omega in [1.0,5.0]
            kb in [1.0,5.0]
            T in [1.0,5.0]
        """,
        "prefix": "* CONST / * x y - exp * CONST * x / y * z w CONST",
    },
    "feynman_III_7_38": {
        "description": """
            omega = 2*mom*B/(h/(2*pi))
            mom in [1.0,5.0]
            B in [1.0,5.0]
            h in [1.0,5.0]
        """,
        "prefix": "* CONST / * x y z",
    },
    "feynman_III_8_54": {
        "description": """
            prob = sin(E_n*t/(h/(2*pi)))**2
            E_n in [1.0,2.0]
            t in [1.0,2.0]
            h in [1.0,4.0]
        """,
        "prefix": "square sin * CONST / * x y z",
    },
    "feynman_III_9_52": {
        "description": """
            prob = (p_d*Ef*t/(h/(2*pi)))*sin((omega-omega_0)*t/2)**2/((omega-omega_0)*t/2)**2
            p_d in [1.0,3.0]
            Ef in [1.0,3.0]
            t in [1.0,3.0]
            h in [1.0,3.0]
            omega in [1.0,5.0]
            omega_0 in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_III_10_19": {
        "description": """
            E_n = mom*sqrt(Bx**2+By**2+Bz**2)
            mom in [1.0,5.0]
            Bx in [1.0,5.0]
            By in [1.0,5.0]
            Bz in [1.0,5.0]
        """,
        "prefix": "* x sqrt + square y + square z square w",
    },
    "feynman_III_12_43": {
        "description": """
            L = n*(h/(2*pi))
            n in [1.0,5.0]
            h in [1.0,5.0]
        """,
        "prefix": "* CONST * x y",
    },
    "feynman_III_13_18": {
        "description": """
            v = 2*E_n*d**2*k/(h/(2*pi))
            E_n in [1.0,5.0]
            d in [1.0,5.0]
            k in [1.0,5.0]
            h in [1.0,5.0]
        """,
        "prefix": "* CONST * x * square y / z w",
    },
    "feynman_III_14_14": {
        "description": """
            I = I_0*( exp(q*Volt/(kb*T)) - 1 )
            I_0 in [1.0,5.0]
            q in [1.0,2.0]
            Volt in [1.0,2.0]
            kb in [1.0,2.0]
            T in [1.0,2.0]
        """,
        "prefix": "* x - exp * y / z * w a CONST",
    },
    "feynman_III_15_12": {
        "description": """
            E_n = 2*U*(1-cos(k*d))
            U in [1.0,5.0]
            k in [1.0,5.0]
            d in [1.0,5.0]
        """,
        "prefix": "* CONST * x - CONST cos * y z",
    },
    "feynman_III_15_14": {
        "description": """
            m = (h/(2*pi))**2/(2*E_n*d**2)
            h in [1.0,5.0]
            E_n in [1.0,5.0]
            d in [1.0,5.0]
        """,
        "prefix": "* square / x z / CONST y",
    },
    "feynman_III_15_27": {
        "description": """
            k = 2*pi*alpha/(n*d)
            alpha in [1.0,5.0]
            n in [1.0,5.0]
            d in [1.0,5.0]
        """,
        "prefix": "* CONST / x * y z",
    },
    "feynman_III_17_37": {
        "description": """
            f = beta*(1+alpha*cos(theta))
            beta in [1.0,5.0]
            alpha in [1.0,5.0]
            theta in [1.0,5.0]
        """,
        "prefix": "* x + CONST * y cos z",
    },
    "feynman_III_19_51": {
        "description": """
            E_n = -m*q**4/(2*(4*pi*epsilon)**2*(h/(2*pi))**2)*(1/n**2)
            m in [1.0,5.0]
            q in [1.0,5.0]
            h in [1.0,5.0]
            n in [1.0,5.0]
            epsilon in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_III_21_20": {
        "description": """
            j = -rho_c_0*q*A_vec/m
            rho_c_0 in [1.0,5.0]
            q in [1.0,5.0]
            A_vec in [1.0,5.0]
            m in [1.0,5.0]
        """,
        "prefix": "* CONST * x * y / z w",
    },
    "feynman_test_1": {
        "description": """
            A = (Z_1*Z_2*alpha*hbar*c/(4*E_n*sin(theta/2)**2))**2
            Z_1 in [1.0,2.0]
            Z_2 in [1.0,2.0]
            alpha in [1.0,2.0]
            hbar in [1.0,2.0]
            c in [1.0,2.0]
            E_n in [1.0,3.0]
            theta in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_test_2": {
        "description": """
            k = m*k_G/L**2*(1+sqrt(1+2*E_n*L**2/(m*k_G**2))*cos(theta1-theta2))
            m in [1.0,3.0]
            k_G in [1.0,3.0]
            L in [1.0,3.0]
            E_n in [1.0,3.0]
            theta1 in [0.0,6.0]
            theta2 in [0.0,6.0]
        """,
        "prefix": "",
    },
    "feynman_test_3": {
        "description": """
            r = d*(1-alpha**2)/(1+alpha*cos(theta1-theta2))
            d in [1.0,3.0]
            alpha in [2.0,4.0]
            theta1 in [4.0,5.0]
            theta2 in [4.0,5.0]
        """,
        "prefix": "* x / - CONST square y + CONST * y cos - z w",
    },
    "feynman_test_4": {
        "description": """
            v = sqrt(2/m*(E_n-U-L**2/(2*m*r**2)))
            m in [1.0,3.0]
            E_n in [8.0,12.0]
            U in [1.0,3.0]
            L in [1.0,3.0]
            r in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_test_5": {
        "description": """
            t = 2*pi*d**(3/2)/sqrt(G*(m1+m2))
            d in [1.0,3.0]
            G in [1.0,3.0]
            m1 in [1.0,3.0]
            m2 in [1.0,3.0]
        """,
        "prefix": "* CONST / square x sqrt * x * y + z w",
    },
    "feynman_test_6": {
        "description": """
            alpha = sqrt(1+2*epsilon**2*E_n*L**2/(m*(Z_1*Z_2*q**2)**2))
            epsilon in [1.0,3.0]
            L in [1.0,3.0]
            m in [1.0,3.0]
            Z_1 in [1.0,3.0]
            Z_2 in [1.0,3.0]
            q in [1.0,3.0]
            E_n in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_test_7": {
        "description": """
            H_G = sqrt(8*pi*G*rho/3-alpha*c**2/d**2)
            G in [1.0,3.0]
            rho in [1.0,3.0]
            alpha in [1.0,2.0]
            c in [1.0,2.0]
            d in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_test_8": {
        "description": """
            K = E_n/(1+E_n/(m*c**2)*(1-cos(theta)))
            E_n in [1.0,3.0]
            m in [1.0,3.0]
            c in [1.0,3.0]
            theta in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_test_9": {
        "description": """
            Pwr = -32/5*G**4/c**5*(m1*m2)**2*(m1+m2)/r**5
            G in [1.0,2.0]
            c in [1.0,2.0]
            m1 in [1.0,5.0]
            m2 in [1.0,5.0]
            r in [1.0,2.0]
        """,
        "prefix": "",
    },
    "feynman_test_10": {
        "description": """
            theta1 = arccos((cos(theta2)-v/c)/(1-v/c*cos(theta2)))
            c in [4.0,6.0]
            v in [1.0,3.0]
            theta2 in [1.0,3.0]
        """,
        "prefix": "",
    },
    "feynman_test_11": {
        "description": """
            I = I_0*(sin(alpha/2)*sin(n*delta/2)/(alpha/2*sin(delta/2)))**2
            I_0 in [1.0,3.0]
            alpha in [1.0,3.0]
            delta in [1.0,3.0]
            n in [1.0,2.0]
        """,
        "prefix": "",
    },
    "feynman_test_12": {
        "description": """
            F = q/(4*pi*epsilon*y**2)*(4*pi*epsilon*Volt*d-q*d*y**3/(y**2-d**2)**2)
            q in [1.0,5.0]
            y in [1.0,3.0]
            Volt in [1.0,5.0]
            d in [4.0,6.0]
            epsilon in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_test_13": {
        "description": """
            Volt = 1/(4*pi*epsilon)*q/sqrt(r**2+d**2-2*r*d*cos(alpha))
            q in [1.0,5.0]
            r in [1.0,3.0]
            d in [4.0,6.0]
            alpha in [0.0,6.0]
            epsilon in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_test_14": {
        "description": """
            Volt = Ef*cos(theta)*(-r+d**3/r**2*(alpha-1)/(alpha+2))
            Ef in [1.0,5.0]
            theta in [0.0,6.0]
            r in [1.0,5.0]
            d in [1.0,5.0]
            alpha in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_test_15": {
        "description": """
            omega_0 = sqrt(1-v**2/c**2)*omega/(1+v/c*cos(theta))
            c in [5.0,20.0]
            v in [1.0,3.0]
            omega in [1.0,5.0]
            theta in [0.0,6.0]
        """,
        "prefix": "",
    },
    "feynman_test_16": {
        "description": """
            E_n = sqrt((p-q*A_vec)**2*c**2+m**2*c**4)+q*Volt
            m in [1.0,5.0]
            c in [1.0,5.0]
            p in [1.0,5.0]
            q in [1.0,5.0]
            A_vec in [1.0,5.0]
            Volt in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_test_17": {
        "description": """
            E_n = 1/(2*m)*(p**2+m**2*omega**2*x**2*(1+alpha*x/y))
            m in [1.0,5.0]
            omega in [1.0,5.0]
            p in [1.0,5.0]
            y in [1.0,5.0]
            x in [1.0,5.0]
            alpha in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_test_18": {
        "description": """
            rho_0 = 3/(8*pi*G)*(c**2*k_f/r**2+H_G**2)
            G in [1.0,5.0]
            k_f in [1.0,5.0]
            r in [1.0,5.0]
            H_G in [1.0,5.0]
            c in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_test_19": {
        "description": """
            pr = -1/(8*pi*G)*(c**4*k_f/r**2+H_G**2*c**2*(1-2*alpha))
            G in [1.0,5.0]
            k_f in [1.0,5.0]
            r in [1.0,5.0]
            H_G in [1.0,5.0]
            alpha in [1.0,5.0]
            c in [1.0,5.0]
        """,
        "prefix": "",
    },
    "feynman_test_20": {
        "description": """
            A = 1/(4*pi)*alpha**2*h**2/(m**2*c**2)*(omega_0/omega)**2*(omega_0/omega+omega/omega_0-sin(beta)**2)
            omega in [1.0,5.0]
            omega_0 in [1.0,5.0]
            alpha in [1.0,5.0]
            h in [1.0,5.0]
            m in [1.0,5.0]
            c in [1.0,5.0]
            beta in [0.0,6.0]
        """,
        "prefix": "",
    },
}
