from htssr.primitives import (
    vocab,
    bijection,
    variables,
    bops,
    uops,
    special_symbol,
    special_parameter_id,
    special_parameter_symbol,
)
from htssr.utils import to_ids

# ----- START OF GENERATION RULES DEFINITION -----

### Feynman

if special_parameter_id is not None:
    parameter_expansion = [[special_parameter_symbol]]
else:
    parameter_expansion = []

expansions = (
    parameter_expansion
    + [
        [bijection[var_id]]
        for var_id in variables
    ]
    + [
        [bijection[op_id],  special_symbol, special_symbol]
        for op_id in bops
    ]
    + [
        [bijection[op_id],  special_symbol]
        for op_id in uops
    ]
)

# ----- END OF GENERATION RULES DEFINITION -----

for expan in expansions:
    for symbol in expan:
        assert symbol in vocab

expansions = [to_ids(tokens) for tokens in expansions]
