import numpy as np
from htssr.utils import precedes, unroll


def make_cls(rolls, noisy_fast=False):
    _n = sum([len(roll) for roll in rolls])
    if noisy_fast:
        cls = np.zeros((_n, _n), dtype=int)
        start = 0
        for roll in rolls:
            _r = len(roll)
            end = start + len(roll)
            cls[start: end, start: end] = np.tril(
                np.ones(
                    (_r, _r),
                    dtype=int,
                )
            )
            start = end
    else:
        all_ids = unroll(rolls)
        cls = np.ones((_n, _n), dtype=int)
        for _0 in range(cls.shape[0]):
            for _1 in range(_0 + 1, cls.shape[0]):
                cls[_0, _1] = int(precedes(all_ids[_0], all_ids[_1]))
                cls[_1, _0] = int(precedes(all_ids[_1], all_ids[_0]))
        cls = cls.T
    return cls

def _make_cls(all_ids, binary=False):
    _n = len(all_ids)
    cls = np.ones((_n, _n), dtype=int)
    if binary:
        for _0 in range(cls.shape[0]):
            for _1 in range(_0 + 1, cls.shape[0]):
                cls[_0, _1] = int(precedes(all_ids[_0], all_ids[_1]))
                cls[_1, _0] = int(precedes(all_ids[_1], all_ids[_0]))
    else:
        for _0 in range(cls.shape[0]):
            for _1 in range(_0 + 1, cls.shape[0]):
                prec01 = precedes(all_ids[_0], all_ids[_1])
                prec10 = precedes(all_ids[_1], all_ids[_0])
                if not (prec01 or prec10):
                    prec01 = 0
                    prec10 = 0
                elif prec01 and prec10:
                    prec01 = 1
                    prec10 = 1
                else:
                    prec01 = 1 if prec01 else 2
                    prec10 = 1 if prec10 else 2
                cls[_0, _1] = prec01
                cls[_1, _0] = prec10
    cls = cls.T
    return cls
