#!/usr/bin/env bash
# assess the ground-truth models that were produced using sympy

# ../pmlb/datasets/strogatz_ \
# ../pmlb/datasets/feynman_

for data in \
  ../pmlb/datasets/strogatz_ \
  ../pmlb/datasets/feynman_
do
  for TN in 0.0 0.01; do

    python analyze.py \
      -script assess_symbolic_model \
      "${data}*" \
      -results results_sym_data \
      -target_noise "$TN" \
      -sym_data \
      -n_trials 1 \
      -m 4000 \
      -time_limit 1:00 \
      -job_limit 130 \
      --local \
      -ml "$1" \
      -tuned \
      --noskips

    # se o comando Python retornar erro, sai do laço interno
    if [ $? -gt 0 ]; then
      break
    fi

  done
done
