#!/usr/bin/env bash
# submit the ground-truth dataset experiment

# for data in \
#   ../pmlb/datasets/strogatz_ \
#   ../pmlb/datasets/feynman_
# do

for data in \
  ../pmlb/datasets/strogatz_ \
  ../pmlb/datasets/feynman_
do
  for TN in 0.0 0.01; do

    python analyze.py \
      "${data}*" \
      -results results_sym_data \
      -target_noise "$TN" \
      -sym_data \
      -n_trials 1 \
      -m 8000 \
      -time_limit 10:00 \
      -job_limit 130 \
      --local \
      -ml "$1" \
      -tuned \
      --noskips

    # se o Python retornar código diferente de zero, interrompe o laço interno
    if [ $? -gt 0 ]; then
      break
    fi

  done
done
