# Datasets download
you could download our collected Watermelon EEG datasets at the link: https://zenodo.org/records/11238929
you could download the SparrKULee dataset at the link: https://rdr.kuleuven.be/dataset.xhtml?persistentId=doi:10.48804/K3VSND

# Introduction
Folder "CVPR": codes to reproduce results of image neural decoding tasks using the reorganized WM-CVPR and SK-CVPR dataset 
Folder "DEAP": codes to reproduce results of emotion recognition tasks using the reorganized WM-DEAP and SK-DEAP dataset 
Folder "KUL": codes to reproduce results of auditory spatial attention detection tasks using the reorganized WM-KUL and SK-KUL dataset 
Folder "CVPR_zero_shot": codes to reproduce results of the so-called "zero-shot" tasks in image neural decoding tasks using the reorganized WM-CVPR and SK-CVPR dataset 
Folder "leave_subjects_out": codes to reproduce results using  "leave subjects out" splitting strategy

# Environment setup
Create and activate conda environment named dreamdiffusion from the env.yaml
```bash
conda env create -f env.yaml
conda activate WM
```
if it fails, you could create a new enviroment and install following packages:
torch==1.13.0
torchaudio==0.13.0
torchvision==0.14.0
h5py==3.7.0
numpy==1.23.3
tqdm==4.64.1 
scikit-learn==1.2.1 
pandas==2.2.2 
matplotlib==3.8.4 
seaborn==0.13.2 
mne 
tensorboard==2.16.2

# Examples to run the codes, more details could be found in codes
## You could change the path such as "/home/public/NIPS/sparrKULee/" to the path you download the dataset mentioned before

## only reorganized the SK dataset
python main.py --reorganize_dataset 1 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type SK --band full --evaluate_only -1 --p lt

## only reorganized the WM dataset
python main.py --reorganize_dataset 1 --project_dir /home/public/NIPS/watermelon_dataset/ --dataset_type WM --band full --evaluate_only -1 --p lt

## only run the KUL_WM_full dataset and model the p(y|x)
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/watermelon_dataset/ --dataset_type WM --band full --evaluate_only 0 --p xy

## only evaluate
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/watermelon_dataset/ --dataset_type WM --band full --evaluate_only 1 --p xy
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/watermelon_dataset/ --dataset_type WM --band full --evaluate_only 1 --p xz

## leave-subject-out, four conditions, more information in codes and paper
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type SK --band full --evaluate_only 0 --split ls
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type SK --band full --evaluate_only 0 --split lsv
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type WM --band full --evaluate_only 0 --split ls
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type WM --band full --evaluate_only 0 --split lsv

## zero-shot
python main.py --reorganize_dataset 1 --project_dir /home/public/NIPS/watermelon_dataset/ --dataset_type WM --band full --evaluate_only -1
python main.py --reorganize_dataset 1 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type SK --band full --evaluate_only -1
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type SK --band full --evaluate_only 0 --split random
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type SK --band full --evaluate_only 0 --split first
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type WM --band full --evaluate_only 0 --split random
python main.py --reorganize_dataset 0 --project_dir /home/public/NIPS/sparrKULee/ --dataset_type WM --band full --evaluate_only 0 --split first