import os
import json


def process_params(options, param_path=None):
    if options.env in [
            'half_cheetah', 'swimmer', 'ant', 'walker2d',
            'reacher', 'hopper', 'invertedPendulum', 'acrobot',
            'cartpole', 'mountain', 'pendulum',
            'gym_petsCheetah', 'gym_petsReacher', 'gym_petsPusher',
            'gym_cheetahO01', 'gym_cheetahO001',
            'gym_cheetahA01', 'gym_cheetahA003',
            'gym_pendulumO01', 'gym_pendulumO001',
            'gym_cartpoleO01', 'gym_cartpoleO001',
            'gym_fant', 'gym_fswimmer', 'gym_fhopper', 'gym_fwalker2d',
            'gym_humanoid', 'gym_slimhumanoid', 'gym_nostopslimhumanoid',
            'cheetah_run']:
        if param_path is None:
            param_path = os.path.join(os.path.curdir, 'configs/params_%s.json' % options.env)
    else:
        raise NotImplementedError

    if options.algo not in ['trpo', 'vime']:
        raise NotImplementedError

    with open(param_path, 'r') as f:
        params = json.load(f)
    params['algo'] = options.algo
    params['num_path_onpol'] = options.num_path_onpol
    params['num_path_random'] = options.num_path_random
    params['split_ratio'] = options.split_ratio
    params['random_seeds'] = options.random_seeds
    params['save_variables'] = options.save_variables
    params['restore_variables'] = options.restore_variables
    params['onpol_iters'] = options.onpol_iters
    assert params['env_name'] == options.env
    # assert options.algo in options.exp_name
    return params
