# fix small bug with parse_objects from alfworld
import string
import alfworld.gen.constants as constants

def parse_objects(desc):
    '''
    extract objects after "you see" and before "your task is to:"
    '''
    # TODO: replace with a noun-phrase extractor
    objs = []
    if "you see" in desc.lower():
        obj_str = desc.lower().replace(" and", ",")
        obj_str = obj_str.split("you see ", 1)[1]
        obj_str = obj_str.partition("your task is to:")[0]
        for s in obj_str.split(","):
            item = s.translate(str.maketrans('', '', string.punctuation))
            item = item.strip().replace("a ", "", 1)# XXX CODE CHANGED HERE
            if item:
                objs.append(item)
    return objs


def extract_admissible_commands_with_heuristics(intro, frame_desc, feedback,
                                                curr_recep, inventory):
    '''
    Heavily engineered admissible commands extraction. Lots of commonsense and heuristics used to prune list.
    '''

    at_recep = str(curr_recep) if curr_recep != "nothing" else ""
    at_recep_type = at_recep.split()[0] if at_recep else ""
    in_inv = str(inventory[0]).lower() if len(inventory) > 0 else ""

    OPENABLE_RECEPTACLES = [r.lower() for r in constants.OPENABLE_CLASS_LIST]

    assert intro  # intro should be non-empty

    admissible_commands = []
    templates = [
        "go to {recep}",
        "open {recep}",
        "close {recep}",
        "take {obj} from {recep}",
        "put {obj} in/on {recep}",
        "use {lamp}",
        "heat {obj} with {microwave}",
        "cool {obj} with {fridge}",
        "clean {obj} with {cleaner}",
        "slice {obj} with {knife}",
        "inventory",
        "look",
        "examine {obj}",
        "examine {recep}"
    ]

    # parse interactable and navigable objects
    receps = parse_objects(intro)
    objects = parse_objects(frame_desc) if frame_desc else []
    lamps = [obj for obj in objects if 'lamp' in obj]
    microwaves = [obj for obj in receps if 'microwave' in obj]
    cleaners = [obj for obj in receps if 'sink' in obj or 'bathtub' in obj]
    fridges = [obj for obj in receps if 'fridge' in obj]
    knives = [obj for obj in receps if 'knife' in obj]

    # populate templates
    for t in templates:
        if 'take {obj} from {recep}' in t:
            if at_recep and not in_inv:
                for obj in objects:
                    if 'desklamp' not in obj and 'floorlamp' not in obj:
                        admissible_commands.append(t.format(recep=at_recep, obj=obj))
        elif 'put {obj} in/on {recep}' in t:
            if in_inv and at_recep:
                admissible_commands.append(t.format(recep=at_recep, obj=in_inv))
        elif '{obj}' in t and '{microwave}' in t:
            if 'microwave' in at_recep and in_inv:
                for microwave in microwaves:
                    admissible_commands.append(t.format(microwave=microwave, obj=in_inv))
        elif '{obj}' in t and '{fridge}' in t:
            if 'fridge' in at_recep and in_inv:
                for fridge in fridges:
                    admissible_commands.append(t.format(fridge=fridge, obj=in_inv))
        elif '{obj}' in t and '{cleaner}' in t:
            if ('sink' in at_recep or 'bathtub' in at_recep) and in_inv:
                for cleaner in cleaners:
                    admissible_commands.append(t.format(cleaner=cleaner, obj=in_inv))
        elif '{obj}' in t and '{knife}' in t:
            if 'knife' in in_inv:
                for knife in knives:
                    for obj in objects:
                        admissible_commands.append(t.format(knife=knife, obj=obj))
        elif 'open {recep}' in t:
            if at_recep:
                if at_recep_type in OPENABLE_RECEPTACLES: # and ("is closed" in feedback or "You close" in feedback):
                    admissible_commands.append(t.format(recep=at_recep))
        elif 'close {recep}' in t:
            if at_recep:
                if at_recep_type in OPENABLE_RECEPTACLES: # and "is open" in feedback:
                    admissible_commands.append(t.format(recep=at_recep))
        elif 'examine {recep}' in t:
            if at_recep:
                admissible_commands.append(t.format(recep=at_recep))
        elif 'examine {obj}' in t:
            if in_inv:
                admissible_commands.append(t.format(obj=in_inv))
        elif 'go to {recep}' in t:
            for recep in receps:
                if recep != at_recep:
                    admissible_commands.append(t.format(recep=recep))
        elif '{recep}' in t:
            for recep in receps:
                admissible_commands.append(t.format(recep=recep))
        elif '{obj}' in t:
            for obj in objects:
                admissible_commands.append(t.format(obj=obj))
        elif '{lamp}' in t:
            for lamp in lamps:
                admissible_commands.append(t.format(lamp=lamp))
        else:
            admissible_commands.append(t)

    return admissible_commands
