class CaptionArgs(object):
    lm_base = 'gpt2'
    n_deep_prompt_tokens = 0
    n_prompt_tokens = 0
    n_obs_embed_tokens = 10
    finetune_lm = True
    lm_eval_mode = False
    prompt_arch = 'clip'
    obs_type = 'imgcap'
    rank_admissible = False
    dynamic_length_eval = True
    max_context_tokens = 1000
    #
    shared_prompt_proj = False
    prompt_dropout_prob = 0.0
    init_from_vocab = False
    detach_obs_forward = False
    #
    load_checkpoint = 'checkpoints/cvpr/captionsall/gpt2_ft_clip_imgcap_10_0.tar'
    #
    train_samples = 0
    batch_size = 8
    epochs = 1
    prim_lw = 'unif.100'
    aux_lw = 'unif.10'

class AffordanceArgs(object):
    lm_base = 'gpt2'
    n_deep_prompt_tokens = 0
    n_prompt_tokens = 0
    n_obs_embed_tokens = 10
    finetune_lm = True
    lm_eval_mode = False
    prompt_arch = 'clip'
    obs_type = 'imgadm'
    rank_admissible = False
    dynamic_length_eval = True
    max_context_tokens = 1000
    #
    shared_prompt_proj = False
    prompt_dropout_prob = 0.0
    init_from_vocab = False
    detach_obs_forward = False
    #
    load_checkpoint = 'checkpoints/cvpr/affordance/gpt2_ft_clip_imgadm_2_0.tar'
    #
    train_samples = 0
    batch_size = 8
    epochs = 1
    prim_lw = 'unif.100'
    aux_lw = 'unif.10'

class VP2AuxArgs(object):
    lm_base = 'gpt2'
    n_deep_prompt_tokens = 10
    n_prompt_tokens = 8
    n_obs_embed_tokens = 10
    finetune_lm = True
    lm_eval_mode = False
    prompt_arch = 'clip'
    obs_type = 'imgauxcap'
    rank_admissible = False
    dynamic_length_eval = True
    max_context_tokens = 1000
    #
    shared_prompt_proj = False
    prompt_dropout_prob = 0.0
    init_from_vocab = False
    detach_obs_forward = False
    #
    load_checkpoint = 'checkpoints/iclr/best/gpt2_ft_clip_imgauxcap_99_1.tar'
    #
    train_samples = 0
    batch_size = 8
    epochs = 1
    prim_lw = 'unif.100'
    aux_lw = 'unif.10'

class VP2Args(object):
    lm_base = 'gpt2'
    n_deep_prompt_tokens = 0
    n_prompt_tokens = 0
    n_obs_embed_tokens = 10
    finetune_lm = True
    lm_eval_mode = False
    prompt_arch = 'clip'
    obs_type = 'img'
    rank_admissible = False
    dynamic_length_eval = True
    max_context_tokens = 1000
    #
    shared_prompt_proj = False
    prompt_dropout_prob = 0.0
    init_from_vocab = False
    detach_obs_forward = False
    #
    load_checkpoint = 'checkpoints/cvpr/align-1obs/gpt2_ft_clip_img_49_0.tar'
    #
    train_samples = 0
    batch_size = 8
    epochs = 1
    prim_lw = 'unif.100'
    aux_lw = 'unif.10'

class VHomeCaptionArgs(CaptionArgs):
    load_checkpoint = 'checkpoints/cvpr/virtualhome2/gpt2_ft_clip_imgcap_25_0.tar'

class VHomeVP2Args(VP2Args):
    load_checkpoint = 'checkpoints/cvpr/virtualhome2/gpt2_ft_clip_img_49_0.tar'

class VHomeAffordanceArgs(AffordanceArgs):
    load_checkpoint = 'checkpoints/cvpr/virtualhome2/gpt2_ft_clip_imgadm_2_0.tar'
