# prompt-subtasks

## Installation

Create an environment for python 3.8
```
conda create -n prompt python=3.8
```

#### Install alfworld
```
git clone <alfworld url>
cd alfworld
```

Edit the requirements.txt and remove the pytorch requirements (pytorch versions are too old)
```
pip install -r requirements.txt
```

### Install pytorch
```
conda install pytorch torchvision torchaudio cudatoolkit=11.3 -c pytorch
```

### Install promptrl package
```
pip install -e .
```


## Example Commands

Help:
```
python scripts/main.py -h
```

Testing with alfworld:
```
python -m ipdb -c c scripts/main.py --no-wandb --batch-size=12 --epochs=30 --eval-samples=1 --lm-base=gpt2 --n-deep-prompt-tokens=10 --n-prompt-tokens=0 --obs-type=lang --prompt-arch=unit --seed=0 --task-type=alf-pick-place
```
