#!/bin/bash

# Lines that begin with #SBATCH specify commands to be used by SLURM for scheduling
#SBATCH --job-name=testing                            # sets the job name if not set from environment
#SBATCH --array=0-19                                    # Submit 8 array jobs, throttling to 4 at a time
#SBATCH --output logs/%x_%A_%a.log                   # redirect STDOUT to; %j is the jobid, _%A_%a is array task id
#SBATCH --error logs/%x_%A_%a.log                    # redirect STDERR to; %j is the jobid,_%A_%a is array task id
#SBATCH --account=scavenger                           # set QOS, this will determine what resources can be requested
#SBATCH --qos=scavenger                                 # set QOS, this will determine what resources can be requested
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=4
#SBATCH --partition=scavenger
#SBATCH --mem 16gb                                      # memory required by job; MB will be assumed
#SBATCH --mail-user <email_id>
#SBATCH --mail-type=END,TIME_LIMIT,FAIL,ARRAY_TASKS
#SBATCH --time=2:00:00                                 # how long will the job will take to complete; format=hh:mm:ss

# seed=$(( $SLURM_ARRAY_TASK_ID % 10 + 1001))

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --e2e
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --e2e

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model htbd_alexnet --normalize --from_scratch
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model resnet18 --normalize --from_scratch

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense cutmix
# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense mixup
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense cutmix
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense mixup

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense cutmix --e2e
# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense mixup --e2e
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense cutmix --e2e
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense mixup --e2e

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model htbd_alexnet --normalize --defense cutmix --from_scratch
# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model htbd_alexnet --normalize --defense mixup --from_scratch
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model resnet18 --normalize --defense cutmix --from_scratch
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model resnet18 --normalize --defense mixup --from_scratch

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense madry
# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense activation_clustering
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense madry
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense activation_clustering

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense madry --e2e
# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model htbd_alexnet --normalize --defense activation_clustering --e2e
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense madry --e2e
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./CHECKPOINTS/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --normalize --defense activation_clustering --e2e

# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model htbd_alexnet --normalize --defense madry --from_scratch
# python benchmark_test.py --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model htbd_alexnet --normalize --defense activation_clustering --from_scratch
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model resnet18 --normalize --defense madry --from_scratch
# python benchmark_test.py --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model resnet18 --normalize --defense activation_clustering --from_scratch

# seed=$(( $SLURM_ARRAY_TASK_ID % 2 + 1))
# python benchmark_test.py --poisons_path baseline/htbd_recur_19/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.01_batchsize=128_maze=7_tol=1.0/recur_resnet_19_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_19 --normalize --str c19t19
seed=$(( $SLURM_ARRAY_TASK_ID % 5 + 1))
python benchmark_test.py --poisons_path baseline/htbd_recur_19/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_15_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_15 --normalize --str c19t15
# python benchmark_test.py --poisons_path baseline/htbd_recur_19/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_11_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_11 --normalize --str c19t11
# python benchmark_test.py --poisons_path baseline/htbd_recur_19/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_7_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_7 --normalize --str c19t7

# seed=$(( $SLURM_ARRAY_TASK_ID % 2 + 1))
# python benchmark_test.py --poisons_path baseline/htbd_recur_11/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.01_batchsize=128_maze=7_tol=1.0/recur_resnet_19_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_19 --normalize --str c11t19
seed=$(( $SLURM_ARRAY_TASK_ID % 5 + 1))
python benchmark_test.py --poisons_path baseline/htbd_recur_11/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_15_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_15 --normalize --str c11t15
# python benchmark_test.py --poisons_path baseline/htbd_recur_11/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_11_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_11 --normalize --str c11t11
# python benchmark_test.py --poisons_path baseline/htbd_recur_11/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_7_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_7 --normalize --str c11t7

# seed=$(( $SLURM_ARRAY_TASK_ID % 2 + 1))
# python benchmark_test.py --poisons_path baseline/htbd_recur_7/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.01_batchsize=128_maze=7_tol=1.0/recur_resnet_19_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_19 --normalize --str c7t19
seed=$(( $SLURM_ARRAY_TASK_ID % 5 + 1))
python benchmark_test.py --poisons_path baseline/htbd_recur_7/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_15_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_15 --normalize --str c7t15
# python benchmark_test.py --poisons_path baseline/htbd_recur_7/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_11_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_11 --normalize --str c7t11
# python benchmark_test.py --poisons_path baseline/htbd_recur_7/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 800 --model_path ./recur/checkpoints/cifar10_modified_resnet_checkpoint/${seed}/lr=0.1_batchsize=128_maze=7_tol=1.0/recur_resnet_7_cifar10_SGD_batchsize=128_epoch=199.pth --model recur_resnet_7 --normalize --str c7t7