# -*- coding: utf-8 -*-
"""
Created on Fri Jun 24 00:33:18 2022

@author: 10732
"""

import torch
import torch.optim as optim
# from .optimizer import Optimizer, required
def pow_tensor(tensor, p):
    singp = torch.sign(tensor)
    temp = (tensor.abs()).pow(p)
    temp.mul_(singp)
    return temp

class MD(optim.SGD):


    def __init__(self, params, args, lr=0.01, momentum=0, dampening=0,
                 weight_decay=0, nesterov=False):
        self.args = args
        # if lr is not required and lr < 0.0:
        #     raise ValueError("Invalid learning rate: {}".format(lr))
        if momentum < 0.0:
            raise ValueError("Invalid momentum value: {}".format(momentum))
        if weight_decay < 0.0:
            raise ValueError("Invalid weight_decay value: {}".format(weight_decay))

        defaults = dict(lr=lr, momentum=momentum, dampening=dampening,
                        weight_decay=weight_decay, nesterov=nesterov)
        if nesterov and (momentum <= 0 or dampening != 0):
            raise ValueError("Nesterov momentum requires a momentum and zero dampening")
        # super(MD, self).__init__(params, defaults)
        super().__init__(params, args.lr, momentum, dampening, weight_decay, nesterov)

    def __setstate__(self, state):
        super(MD, self).__setstate__(state)
        for group in self.param_groups:
            group.setdefault('nesterov', False)

    @torch.no_grad()
    def step(self, closure=None):
        """Performs a single optimization step.

        Arguments:
            closure (callable, optional): A closure that reevaluates the model
                and returns the loss.
        """
        loss = None
        if closure is not None:
            with torch.enable_grad():
                loss = closure()

        for group in self.param_groups:
            weight_decay = group['weight_decay']
            momentum = group['momentum']
            dampening = group['dampening']
            nesterov = group['nesterov']

            for p in group['params']:
                if p.grad is None:
                    continue
                d_p = p.grad
                if weight_decay != 0:
                    d_p = d_p.add(p, alpha=weight_decay)
                if momentum != 0:
                    param_state = self.state[p]
                    if 'momentum_buffer' not in param_state:
                        buf = param_state['momentum_buffer'] = torch.clone(d_p).detach()
                    else:
                        buf = param_state['momentum_buffer']
                        buf.mul_(momentum).add_(d_p, alpha=1 - dampening)
                    if nesterov:
                        d_p = d_p.add(buf, alpha=momentum)
                    else:
                        d_p = buf
                # tmp = pow_tensor(p.clone().detach(), self.args.p)
                # tmp.add_(d_p, alpha=-group['lr'])
                # tmp = pow_tensor(tmp, 1/self.args.p)
                # p.add_(d_p, alpha=-group['lr'])
                # p = tmp

        return loss