# MODEL=CLIP_B16
MODEL=dino
OUTPUT_DIR=
DATA_PATH=/workspace/sync/imagenet-1k

echo $OUTPUT_DIR
mkdir -p $OUTPUT_DIR
cp $0 $OUTPUT_DIR

CUDA_VISIBLE_DEVICES=4,5,6,7 OMP_NUM_THREADS=1 python -m torch.distributed.launch --nproc_per_node=4 --master_port=29537 run_class_finetuning.py \
    --model ${MODEL} --data_path $DATA_PATH \
    --input_size 224 \
    --finetune True \
    --num_workers 6 \
    --output_dir ${OUTPUT_DIR} \
    --log_dir ${OUTPUT_DIR} \
    --batch_size 128 --lr 2e-3 --update_freq 2 \
    --warmup_epochs 10 --epochs 50 \
    --layer_decay 0.6 \
    --drop_path 0 \
    --dist_eval --eval_all --save_ckpt \
    --save_ckpt_freq 1 \
    --clip_mean_and_std \
    --layer_scale_init_value 0 \
    --weight_decay 0.05 --mixup 0.0 --cutmix 0.0 \
    --nb_classes 1000  --model_prefix visual.\
    --model_ema --model_ema_decay 0.9998 \
    2>&1 | tee -a ${OUTPUT_DIR}/log.txt \
