import argparse
import pandas as pd

parser = argparse.ArgumentParser()
parser.add_argument("-task", type=str, required=True, help="task typr")
args = parser.parse_args()
task= args.task
if args.task == 'full': 
    overall_forget_classes = list(range(5)) 
    dataset = 'Cifar100'
elif args.task == 'sub': 
    overall_forget_classes = [54, 62, 70, 82, 92]
    dataset = 'Cifar20'
    

metrics = ['ForgetValidAcc', 'ForgetTrainAcc','RetainValidAcc', 'TestAcc' , 'ForgottenTrainAcc', 'ForgottenValidAcc', 'MIA' ]

methods = [ 'retrain','finetune','badteacher','salun','ssd','mumis']

# 
# 'mumis','scrub',
# from collections import defaultdict
# data = defaultdict(lambda: defaultdict(list))
data = dict.fromkeys(metrics)
for m in metrics: 
    data[m] = {method:[] for method in methods}
for forget_class in overall_forget_classes:
    res_path = f'results/sequential_{args.task}-ResNet18-{dataset}-forget-{forget_class}.csv'
    results = pd.read_csv(res_path) 
    for _, row in results.iterrows():
        method = row['Method']  # 获取当前行的方法名
        for metric in metrics:
            metric_value = row[metric]  # 这里是获取当前行当前指标的值
            print(method, metric, metric_value)  # 打印当前方法和指标的值
            data[metric][method].append(metric_value)  # 将值添加到 data 中

import json
seq_res_dir = '/opt/data/private/MUMis-pami/figure/sequential-MU/'
with open(f'{seq_res_dir}/data/{args.task}.json', 'w') as f:
    json.dump(data, f)
print(data)
