# pc_rl

Reinforcement learning on point clouds with representation learning.

## Getting Started (installation from source)

pc_rl can be installed with Python 3.10. We recommend using conda/mamba to manage your Python environment.

```
conda create -n pc_rl -f env.yaml
conda activate pc_rl
```

Next, install parllel and pc_rl itself
```
pip install -e dependencies/parllel
pip install -e .
```

### Troubleshooting

It may be necessary to adjust the LD_LIBRARY path if you get error when importing dependencies.

```
conda env config vars set LD_LIBRARY_PATH=$CONDA_PREFIX/lib:$LD_LIBRARY_PATH
```

## Environments

Each environment suite can be installed independently.

### sofa_env

- Make sure to install sofa after installing all other dependencies, so that it is compiled with all the correct dependencies (e.g. numpy version)
- Install sofa according to [instructions in sofa_env](https://github.com/ScheiklP/sofa_env/blob/main/docs/source/setting_up_sofa.rst). Tip: if you have multiple sofa builds on your system, build into a folder within this repo for better organization.
- Install sofa_env python package with:
```
pip install git+https://github.com/ScheiklP/sofa_env
```

### Maniskill2

Install with:
```
pip install mani_skill2
```

Make sure you download the required assets for each environment with:
```
python -m mani_skill2.utils.download_asset ${ENV_ID}
```

### Metaworld

Install with:
```
pip install git+https://github.com/Farama-Foundation/Metaworld.git@master#egg=metaworld
```
