## FlexConv: Continuous Kernel Convolutions With Differentiable Kernel Sizes

#### Contribute

To contribute remember to install pre-commit. In the repository and in the correct environment, execute:
```
pip install pre-commit
pre-commit install
```

### Repository structure

#### Folders

This repository is organized as follows:

* `ckconv` contains the main PyTorch library of our model.

* `ckernel_fitting` contains source code to run experiments to approximate convolutional filters via MLPs. Please see `ckernel_fitting/README.md` for further details.

* `demo` provides some minimalistic examples on the usage of CKConvs and the construction of CKCNNs.

* `models` contains the models used throughout our experiments.

* `probspec_routines` contains routines specific to some of the problems considered in this paper.

* `runs` contains the `.sh` files with the corresponding arguments used to run our experiments.

### Reproduce

#### Install

###### conda *(recommended)*
In order to reproduce our results, please first install the required dependencies. This can be done by:
```
conda env create -f conda_requirements.yaml
```
This will create the conda environment `ckconv` with the correct dependencies.

###### pip
The same conda environment can be created with `pip` by running:
```
conda create -n ckconv python=3.7
conda install pytorch==1.7.0 torchvision==0.8.1 torchaudio=0.7.0 cudatoolkit=10.1 -c pytorch
conda activate ckconv
pip install -r requirements.txt
```

###### manual installation
If you prefer to construct the conda environment manually, please follow the commands speficiend in `manual_installation.txt`

#### Experiments and `config` files
To reproduce the experiments in the paper, please follow the configurations given in the file `runs/my_experiment.sh`

Specifications on the parameters specified via the `argsparser` can be found in the corresponding `config.py` files.

#### Pretrained models
To use pretrained models, please add the argument `--config.pretrained==True` to the corresponding execution `.sh` file.

#### Recommendations and details

###### Replacing fft convolutions with spatial convolutions
We leverage the convolution theorem in our experiments to accelerate the computation of the convolution operations (see
`causal_fftconv` in `ckconv/nn/functional/causalconv.py`), and we strongly recommend using fft convolutions.
However, for some applications it might be desirable to rely on spatial convolutions, e.g., small conv. kernels. This can be easily modified by replacing
the call to `causal_fftconv` in the forward pass of the `CKConv` class (`ckconv/nn/ckconv.py:182`)  by the function `causal_conv` found in `ckconv/nn/functional/causalconv.py`.

### Cite
If you found this work useful in your research, please consider citing:
```
anonimyzed
```