#!/bin/bash

EXPERIMENT_SCRIPT=${EXPERIMENT_SCRIPT:-"source/experiment.py"}

for category in "SND" "EMG" "GND" "t-distribution"; do
    for size in 16; do
        for distance in 0.01 0.02 0.03 0.04; do
            for seed in {0..9}; do
                python $EXPERIMENT_SCRIPT \
                    --category $category \
                    --size $size \
                    --signal 0 \
                    --workers 96 \
                    --iter 120 \
                    --seed $seed \
                    --distance 0
            done
        done
    done
done