import numpy as np
from abc import ABC, abstractmethod

class BaseMOMAB:
    '''
    m : Number of objectives
    t : start time
    '''
    def __init__(self, m):
        self.m = m
        self.t = 1

    @abstractmethod
    def select_ac(self, contexts = None):  
        '''
        return index of arm

        contexts : set of contexts (K,d)
        '''
        raise NotImplementedError

    @abstractmethod
    def update(self, rewards, context = None):
        '''
        update with given reward

        rewards : (m,)
        context : (d,)
        '''
        raise NotImplementedError
