#Pre-training Text-to-Text Transformers to Write and Reason with Concepts

## Installation

```python
pip install -r requirements.txt
```

## Pre-training


### Dataset Generation for pre-training :

wiki.doc : https://dumps.wikimedia.org/enwiki/

```python
cat wiki.doc | tail -n +500000 | head -n 500000 > wiki.train.raw
cat wiki.doc | tail -n +5000 | head -n 5000 > wiki.valid.raw
```

Generate concept_order_recovering dataset.

```python
python3 generate_concept_order_recovering.py
```

Generate concept_to_sentence dataset.

```python
python3 generate_concept_to_sentence.py
```

Generate generative_qa style contrastive objective dataset.

```python
python3 generate_generative_qa_mix.py
```

Generate mix dataset with above three datasets.

```python
python3 generate_mix.py
```

### Pre-train each models :

To run the Mix-Training :
```python
python3 finetune_model.py \
    --data_dir datasets/mix \
    --output_dir outputs/mix \
    --n_gpu 8 \
    --gpu_nums 0,1,2,3,4,5,6,7
    --fp_16 False \
    --max_seq_length 256 \
    --learning_rate 5e-7 \
    --weight_decay 0.01 \
    --warmup_steps 10000 \
    --adam_epsilon 1e-6 \
    --num_train_epochs 3 \
    --train_batch_size 8 \
    --gradient_accumulation_steps 8
```

To run the Joint-training from Mix :
```python
python3 finetune_gan_style.py \
    --num_train_epochs 3 \
    --fp_16 False \
    --max_seq_length 256 \
    --learning_rate 5e-7 \
    --output_dir outputs/joint_mix \
    --weight_decay 0.01 \
    --warmup_steps 10000 \
    --adam_epsilon 1e-6 \
    --train_batch_size 8 \
    --gradient_accumulation_steps 8 \
    --data_dir datasets/generative_qa_mix \
    --checkpoint_dir outputs/mix \
    --n_gpu 8 \
    --gpu_nums 0,1,2,3,4,5,6,7
```

## Automatic Hyper-parameter tuning for downstream tasks:

### CSQA:

1. To run the hyper-parameter tuning experiments, use the following command,

```python
python3 run_hyperparameter_tuning.py \
    --finetune_file finetune_csqa.py \
    --predict_file predict_csqa.py \
    --eval_file eval_csqa.py \
    --param_file hyperparameter_tuning_utils/csqa_params_tuning.json \
    --root_output_dir outputs/<output_dir> \
    --finetune_checkpoint_dir outputs/<checkpoint_dir> \
    --n_gpu 4 \
    --gpu_nums 0,1,2,3
```

where, <br>
<output_dir> is the root output directory for storing the results of the each setting of hyper parameter tuning experiments.
Eg: csqa_tuning_from_<checkpoint_dir> <br>
<checkpoint_dir> is the checkpoint directory which contains the model checkpoint to load during the fine-tuning of downstream task.

2. To summarize the results of fine-tuning experiments to a csv file, use the following command,

```python
python3 summarize_hyperparameter_tuning_outputs.py \
    --tuning_output_dir outputs/<output_dir> \
    --param_file hyperparameter_tuning_utils/csqa_params_tuning.json \
    --output_file outputs/<results_output_file>.csv
```

where, <br>
<output_dir> is the root output directory that is used while runing the hyper-parameter tuning experiments. <br>
<results_output_file>.csv is the final csv file that summarizes the various tuning experiments result.

Similarly for other tasks, refer to the commands in the following sections, 

### PIQA:

```python
python3 run_hyperparameter_tuning.py \
    --finetune_file finetune_piqa.py \
    --predict_file predict_piqa.py \
    --eval_file eval_piqa.py \
    --param_file hyperparameter_tuning_utils/piqa_params_tuning.json \
    --root_output_dir outputs/<output_dir> \
    --finetune_checkpoint_dir outputs/<checkpoint_dir> \
    --n_gpu 4 \
    --gpu_nums 0,1,2,3
```

```python
python3 summarize_hyperparameter_tuning_outputs.py \
    --tuning_output_dir outputs/<output_dir> \
    --param_file hyperparameter_tuning_utils/piqa_params_tuning.json \
    --output_file outputs/<results_output_file>.csv
```

### OBQA without KB:

```python
python3 run_hyperparameter_tuning.py \
    --finetune_file finetune_openbookqa.py \
    --predict_file predict_openbookqa.py \
    --eval_file eval_openbookqa.py \
    --param_file hyperparameter_tuning_utils/obqa_without_kb_params_tuning.json \
    --root_output_dir outputs/<output_dir> \
    --finetune_checkpoint_dir outputs/<checkpoint_dir> \
    --n_gpu 4 \
    --gpu_nums 0,1,2,3
```

```python
python3 summarize_hyperparameter_tuning_outputs.py \
    --tuning_output_dir outputs/<output_dir> \
    --param_file hyperparameter_tuning_utils/obqa_without_kb_params_tuning.json \
    --output_file outputs/<results_output_file>.csv
```

### ANLI:

```python
python3 run_hyperparameter_tuning.py \
    --finetune_file finetune_anli.py \
    --predict_file predict_anli.py \
    --eval_file eval_anli.py \
    --param_file hyperparameter_tuning_utils/anli_params_tuning.json \
    --root_output_dir outputs/<output_dir> \
    --finetune_checkpoint_dir outputs/<checkpoint_dir> \
    --n_gpu 4 \
    --gpu_nums 0,1,2,3
```

```python
python3 summarize_hyperparameter_tuning_outputs.py \
    --tuning_output_dir outputs/<output_dir> \
    --param_file hyperparameter_tuning_utils/anli_params_tuning.json \
    --output_file outputs/<results_output_file>.csv
```

### CommonGEN:

```python
python3 run_hyperparameter_tuning.py \
    --finetune_file finetune_commongen.py \
    --predict_file predict_commongen.py \
    --param_file hyperparameter_tuning_utils/anli_params_tuning.json \
    --root_output_dir outputs/<output_dir> \
    --finetune_checkpoint_dir outputs/<checkpoint_dir> \
    --n_gpu 4 \
    --gpu_nums 0,1,2,3
```
