# source ~/.bashrc
INPUT_FILE=~/Commonsense_Pretraining/commongen/test.source
TRUTH_FILE=~/Commonsense_Pretraining/commongen/test.target
PRED_FILE=$1

echo ${INPUT_FILE}
echo ${TRUTH_FILE}
echo ${PRED_FILE}

echo "Start running ROUGE"

cd ~/CommonGen/methods/unilm_based
python unilm/src/gigaword/eval.py --pred ${PRED_FILE}   --gold ${TRUTH_FILE} --perl


echo "BLEU/METER/CIDER/SPICE"
cd ~/CommonGen/evaluation/Traditional/eval_metrics/
python eval.py --key_file ${INPUT_FILE} --gts_file ${TRUTH_FILE} --res_file ${PRED_FILE}


echo "PivotScore"
cd ~/CommonGen/evaluation/PivotScore
python evaluate.py --pred ${PRED_FILE}   --ref ${TRUTH_FILE} --cs ${INPUT_FILE} --cs_str ~/CommonGen/dataset/final_data/commongen/commongen.test.cs_str.txt

echo "_________________"
echo "Correct BERTScore"
cd ~/CommonGen/evaluation/BERTScore
CUDA_VISIBLE_DEVICES=3 python evaluate.py --pred ${PRED_FILE}   --ref ${TRUTH_FILE} --cs ~/CommonGen/dataset/final_data/commongen/commongen.test.src_alpha.txt