# HMPN
A package for Heterogeneous Message Passing Networks in [PyTorch Geometric](https://pytorch-geometric.readthedocs.io/en/latest/).
Supports message passing networks for homogeneous and heterogeneous input graphs.
This package is under active development and meant to be used as a building block for downstream GNN applications.


## Supported Features
* Homogeneous message passing networks based on the pytorch geometric "Data" object
* Heterogeneous message passing networks based on the pytorch geometric "HeteroData" object
* Global features for the graph as a graph-wise attribute `u`
* Empty node, edge and global features. These must have a shape of (0) in the respective dimension.
* Linear and MLP-Based input embeddings
* Multiple parallel aggregation functions (Sum, Mean, Max, Min), following [PNA](https://arxiv.org/abs/2004.05718)
* Residual Connections and Layer Norm between message passing steps
* Common regularization techniques for the individual MLPs
* GPU support
* Output conversions to node, edge and graph level

## Installation
```bash
pip install -e .
```
if this fails, try
```bash
pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cpu
pip install torch_geometric
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.0.0+cpu.html
pip install -e .
``` 

## Usage
Calling `hmpn.get_hmpn.get_hmpn()` returns a message passing model based on input graph sizes, a latent dimension and a
base config. Depending on the graph, a homogeneous or heterogeneous model is returned. 
The `examples` folder contains a simple `homogeneous_example.py` and a slightly more complex `heterogeneous_example.py`. 
Additional information for the different configuration options are given in the `config.yaml` file.

