# LTSGNS-MP
This is the source code for "Latent task-specific Graph Network Simulators" using Motion Primitives.

## Installation
Clone this repository. Then setup a python virtual environment with python 3.10. We recommend using [micromamba](https://mamba.readthedocs.io/en/latest/installation/micromamba-installation.html), but conda or venv should also work.

Inside the environment, install Pytorch using

```pip3 install torch==2.1.0 torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118```

Then install the other torch dependencies using

```
pip install --upgrade torch-spline-conv -f https://data.pyg.org/whl/torch-2.1.0+cu118.html
pip install --upgrade torch-cluster -f https://data.pyg.org/whl/torch-2.1.0+cu118.html
pip install --upgrade torch-scatter -f https://data.pyg.org/whl/torch-2.1.0+cu118.html
```

Finally, install this package itself using

```pip install -e .```

when you are in the main folder of this repository.
### Internal Repositories
The following repositories are required to run the code:
- [Multi-DAFT-VI](https://github.com/ALRhub/multi_daft_vi_torch.git)
- [HMPN](https://github.com/ALRhub/hmpn.git)
- [MP_PyTorch](https://github.com/ALRhub/MP_PyTorch.git)
- [clusterduck](https://github.com/ALRhub/clusterduck)

To install them, run
```
git clone https://www.github.com/ALRhub/multi_daft_vi_torch.git ../multi_daft_vi_torch
git clone https://www.github.com/ALRhub/HMPN.git ../hmpn
git clone https://www.github.com/ALRhub/MP_PyTorch.git ../MP_PyTorch
git clone https://www.github.com/ALRhub/clusterduck.git ../clusterduck

pip install -e ../multi_daft_vi_torch
pip install -e ../hmpn
pip install -e ../MP_PyTorch
pip install ../clusterduck
```

Note that clusterduck does not work with `pip -e`, so it has to be installed without the `-e` flag.

### Troubleshooting
- If the following error occurs:
`ModuleNotFoundError: No module named 'torch'`
Then install torch together with torchvision and torchaudio using
`pip3 install torch torchvision torchaudio`
- If you have the problem
` fatal error: Python.h: No such file or directory`
Then install the package `python3.10-dev` using `sudo apt-get install python3.10-dev`

### Details
- Create a folder `datasets/lts_gns` in the root directory of this repository. This folder will be used
to store the datasets as `datasets/lts_gns/$dataset_name/$dataset_name_{train,test,val}.pkl`.
- Mark the src folder as source root in your IDE.

## Run

Running experiments is done via the `main.py` script using [Clusterduck](https://github.com/ALRhub/clusterduck.git).
To get started, you can run a simply debug script as 
```
python main.py +experiment/deformable_plate=mgn_playground env.debug.max_tasks_per_split=5
```

## License
"LTSGNS-MP" is open-sourced under the [MIT license](LICENSE).
