import plotly.graph_objects as go
import dash
import dash_core_components as dcc
import dash_html_components as html
from dash.dependencies import Input, Output

fig = go.Figure(
    go.Surface(
        x = [1,2,3,4,5],
        y = [1,2,3,4,5],
        z = [[0, 1, 0, 1, 0],
             [1, 0, 1, 0, 1],
             [0, 1, 0, 1, 0],
             [1, 0, 1, 0, 1],
             [0, 1, 0, 1, 0]]
    ))


def show_figure_in_dash(fig):
    # update initial camera view upon loading
    fig.update_layout(scene_camera={'up': {'x': 0, 'y': 0, 'z': 1}, 'center': {'x': 0, 'y': 0, 'z': 0}, 'eye': {'x': -0.7720667821180816, 'y': -0.524895528713191, 'z': 0.029033937614632497}, 'projection': {'type': 'perspective'}})

    app = dash.Dash()
    app.layout = html.Div([
        html.Div(id="output"),        # use to print current relayout values
        dcc.Graph(id="fig", figure=fig)
    ])


    @app.callback(
        Output("output", "children"),
        Input("fig", "relayoutData")
    )
    def show_data(data):
        # show camera settings like eye upon change
        return [str(data)]


    app.run_server(debug=False, use_reloader=False)