from typing import List

import numpy as np

from ltsgns_mp.envs.trajectory import Trajectory


class TrajectoryCollection:
    def __init__(self, traj_list: List[Trajectory]):
        self._traj_list = traj_list

    @property
    def traj_list(self) -> List[Trajectory]:
        return self._traj_list

    def __len__(self) -> int:
        return len(self._traj_list)

    def __getitem__(self, item) -> Trajectory:
        return self._traj_list[item]

    def __repr__(self) -> str:
        return f"List of {len(self)} Trajectories, with Traj0='{self[0]}'"
