# AGREE: A Simple Aggregator of Detectors’ Decisions
AGREE is a simple yet effective method to aggregate the decisions based on the soft-probability outputs of multiple trained detectors, possibly provided by a third party.

The features and the adversarial examples have been created by executing this <a href="https://github.com/aldahdooh/detectors_review">code</a>. 

### Current package structure
```
Package
AGREE/
├── README.md
├── checkpoints
│   ├── classifiers
│   │   ├── cifar10
│   │   │   └── rn-best.pt
│   │   └── svhn
│   │       └── rn-best.pt
│   └── detectors
├── config
│   └── config.yaml
├── config_reader_utls
│   ├── attrDict.py
│   └── config_reader_utls.py
├── datasets
│   └── dataset.py
├── losses
│   ├── losses_classifier.py
│   └── losses_detector.py
├── main.py
├── models
│   ├── detector.py
│   └── resnet.py
├── pipeline_testing.py
├── pipeline_training.py
├── agree.py
├── train_detector.py
└── utils
    ├── parser.py
    ├── utils_general.py
    ├── utils_ml.py
    ├── utils_models.py
    └── utils_plot.py
```

#### Usage

To execute AGREE:
- Create the enviroment for AGREE:
```console
foo@bar:~$ conda create --name agree python==3.8.11
```
- Activate the enviroment for AGREE:
```console
foo@bar:~$ source activate agree
```
- Install all the required packages:
```console
(agree) foo@bar:~$ pip3 install -r requirements.txt
```
- Launch the test from CLI for CIFAR10 or SVHN (see <code>config/config.yaml</code>):
```console
(agree) foo@bar:~$ python main.py 
```





