#!/bin/bash
set -e

num_replicates=5
experiment_path="$WRKDIR/sym_fm/exps"
project_path="$WRKDIR/sym_fm/SymmetricRL"
today=`date '+%Y%m%d%H%M%S'`

name=$1
if [ $# -eq 0 ]
then
    echo "No arguments supplied: experiment name required"
    exit 1
fi
shift;
module load anaconda3/5.1.0-gpu
source activate symfm
log_path=$experiment_path/runs/${name}_${today}
mkdir -p $log_path
cat > $log_path/run_script.sh <<EOF
#!/bin/bash
#SBATCH -p dgx-common
#SBATCH --time=18:00:00
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=16
#SBATCH --mem=32000M
#SBATCH --job-name=$name
#SBATCH --array=1-$num_replicates
cd $project_path
python -m playground.train with experiment_dir="$log_path/\$SLURM_ARRAY_TASK_ID" replicate_num=\$SLURM_ARRAY_TASK_ID $@
EOF

cd $log_path

for ((i=1;i<=$num_replicates;i++)) do
    mkdir $i
done

sbatch run_script.sh
echo "Logging at: $log_path"