#!/bin/bash

#$ -l rt_G.small=1
#$ -l h_rt=50:00:00
#$ -j y
#$ -o ./results/log_poemm_lstm_v005-4_clv-aug_bs8_nit5_eval.txt
#$ -cwd

source /etc/profile.d/modules.sh

module load cuda/11.1/11.1.1
module load python/3.6/3.6.12
cd
source cuda11.1/bin/activate

cd /home/acc12335is/documents/G-MulMON

# makde sure the below path are correctly configured before run the project
data_path=/home/acc12335is/documents/data//mulmon_datasets/clevr
repo_path=.
log_path=${repo_path}/logs
data_type=clevr_aug

seed=1027               # random seeds:  0 234 1994 2888 77777 ...
allow_obs=5          # (important) how many observations are available
epoch=1280
which_gpu=1

python eval.py --arch mv_MulMON --datatype ${data_type} --work_mode testing --gpu ${which_gpu} \
--input_dir ${data_path} --output_dir ${log_path} --output_name ev${epoch}_obs${allow_obs} \
--resume_epoch ${epoch} --batch_size 4 --test_batch 50 --vis_batch 0 --analyse_batch 0 --seed ${seed} \
--num_slots 7 --pixel_sigma 0.1 --latent_dim 16 --view_dim 5 --min_sample_views 1 --max_sample_views 6 --num_vq_show ${allow_obs} --num_mc_samples 20 \
--query_nll 1.0 --exp_nll 1.0 --exp_attention 1.0 --kl_latent 1.0 --kl_spatial 1.0 --kl_global=1.0\
--nit_innerloop 5\
--use_bg --eval_all # --eval_dist